/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec;

import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BufferedBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.IESEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.ECKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.EphemeralKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.IESWithCipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.parsers.ECIESPublicKeyParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.ec.ECUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.IESUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.util.BadBlockException;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.BCJcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.util.JcaJceHelper;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.IESKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.IESParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Strings;

public class IESCipher
extends CipherSpi {
    private final JcaJceHelper helper = new BCJcaJceHelper();
    private int ivLength;
    private IESEngine engine;
    private int state = -1;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private AlgorithmParameters engineParam = null;
    private IESParameterSpec engineSpec = null;
    private AsymmetricKeyParameter key;
    private SecureRandom random;
    private boolean dhaesMode = false;
    private AsymmetricKeyParameter otherKeyParameter = null;

    public IESCipher(IESEngine iESEngine) {
        this.engine = iESEngine;
        this.ivLength = 0;
    }

    public IESCipher(IESEngine iESEngine, int n2) {
        this.engine = iESEngine;
        this.ivLength = n2;
    }

    public int engineGetBlockSize() {
        if (this.engine.getCipher() != null) {
            return this.engine.getCipher().getBlockSize();
        }
        return 0;
    }

    public int engineGetKeySize(Key key) {
        if (key instanceof ECKey) {
            return ((ECKey)key).getParameters().getCurve().getFieldSize();
        }
        throw new IllegalArgumentException("not an EC key");
    }

    public byte[] engineGetIV() {
        if (this.engineSpec != null) {
            return this.engineSpec.getNonce();
        }
        return null;
    }

    public AlgorithmParameters engineGetParameters() {
        if (this.engineParam == null && this.engineSpec != null) {
            try {
                this.engineParam = this.helper.createAlgorithmParameters("IES");
                this.engineParam.init((AlgorithmParameterSpec)this.engineSpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString());
            }
        }
        return this.engineParam;
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        String string2 = Strings.toUpperCase((String)string);
        if (string2.equals("NONE")) {
            this.dhaesMode = false;
        } else if (string2.equals("DHAES")) {
            this.dhaesMode = true;
        } else {
            throw new IllegalArgumentException("can't support mode " + string);
        }
    }

    public int engineGetOutputSize(int n2) {
        int n3;
        int n4;
        if (this.key == null) {
            throw new IllegalStateException("cipher not initialised");
        }
        int n5 = this.engine.getMac().getMacSize();
        if (this.otherKeyParameter == null) {
            ECCurve eCCurve = ((ECKeyParameters)this.key).getParameters().getCurve();
            int n6 = (eCCurve.getFieldSize() + 7) / 8;
            n4 = 2 * n6;
        } else {
            n4 = 0;
        }
        if (this.engine.getCipher() == null) {
            n3 = n2;
        } else if (this.state == 1 || this.state == 3) {
            n3 = this.engine.getCipher().getOutputSize(n2);
        } else if (this.state == 2 || this.state == 4) {
            n3 = this.engine.getCipher().getOutputSize(n2 - n5 - n4);
        } else {
            throw new IllegalStateException("cipher not initialised");
        }
        if (this.state == 1 || this.state == 3) {
            return this.buffer.size() + n5 + 1 + n4 + n3;
        }
        if (this.state == 2 || this.state == 4) {
            return this.buffer.size() - n5 - n4 + n3;
        }
        throw new IllegalStateException("cipher not initialised");
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        String string2 = Strings.toUpperCase((String)string);
        if (!(string2.equals("NOPADDING") || string2.equals("PKCS5PADDING") || string2.equals("PKCS7PADDING"))) {
            throw new NoSuchPaddingException("padding not available with IESCipher");
        }
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        IESParameterSpec iESParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                iESParameterSpec = algorithmParameters.getParameterSpec(IESParameterSpec.class);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException("cannot recognise parameters: " + exception.toString());
            }
        }
        this.engineParam = algorithmParameters;
        this.engineInit(n2, key, (AlgorithmParameterSpec)iESParameterSpec, secureRandom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] byArray;
        this.otherKeyParameter = null;
        if (algorithmParameterSpec == null) {
            byArray = null;
            if (this.ivLength != 0 && n2 == 1) {
                byArray = new byte[this.ivLength];
                secureRandom.nextBytes(byArray);
            }
            this.engineSpec = IESUtil.guessParameterSpec((BufferedBlockCipher)this.engine.getCipher(), byArray);
        } else {
            if (!(algorithmParameterSpec instanceof IESParameterSpec)) throw new InvalidAlgorithmParameterException("must be passed IES parameters");
            this.engineSpec = (IESParameterSpec)algorithmParameterSpec;
        }
        byArray = this.engineSpec.getNonce();
        if (this.ivLength != 0 && (byArray == null || byArray.length != this.ivLength)) {
            throw new InvalidAlgorithmParameterException("NONCE in IES Parameters needs to be " + this.ivLength + " bytes long");
        }
        if (n2 == 1 || n2 == 3) {
            if (key instanceof PublicKey) {
                this.key = ECUtils.generatePublicKeyParameter((PublicKey)((PublicKey)key));
            } else {
                if (!(key instanceof IESKey)) throw new InvalidKeyException("must be passed recipient's public EC key for encryption");
                IESKey iESKey = (IESKey)key;
                this.key = ECUtils.generatePublicKeyParameter((PublicKey)iESKey.getPublic());
                this.otherKeyParameter = ECUtil.generatePrivateKeyParameter((PrivateKey)iESKey.getPrivate());
            }
        } else {
            if (n2 != 2 && n2 != 4) throw new InvalidKeyException("must be passed EC key");
            if (key instanceof PrivateKey) {
                this.key = ECUtil.generatePrivateKeyParameter((PrivateKey)((PrivateKey)key));
            } else {
                if (!(key instanceof IESKey)) throw new InvalidKeyException("must be passed recipient's private EC key for decryption");
                IESKey iESKey = (IESKey)key;
                this.otherKeyParameter = ECUtils.generatePublicKeyParameter((PublicKey)iESKey.getPublic());
                this.key = ECUtil.generatePrivateKeyParameter((PrivateKey)iESKey.getPrivate());
            }
        }
        this.random = secureRandom;
        this.state = n2;
        this.buffer.reset();
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(n2, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new IllegalArgumentException("cannot handle supplied parameter spec: " + invalidAlgorithmParameterException.getMessage());
        }
    }

    public byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.buffer.write(byArray, n2, n3);
        return null;
    }

    public int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        this.buffer.write(byArray, n2, n3);
        return 0;
    }

    public byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        if (n3 != 0) {
            this.buffer.write(byArray, n2, n3);
        }
        byte[] byArray2 = this.buffer.toByteArray();
        this.buffer.reset();
        IESWithCipherParameters iESWithCipherParameters = new IESWithCipherParameters(this.engineSpec.getDerivationV(), this.engineSpec.getEncodingV(), this.engineSpec.getMacKeySize(), this.engineSpec.getCipherKeySize());
        if (this.engineSpec.getNonce() != null) {
            iESWithCipherParameters = new ParametersWithIV((CipherParameters)iESWithCipherParameters, this.engineSpec.getNonce());
        }
        ECDomainParameters eCDomainParameters = ((ECKeyParameters)this.key).getParameters();
        if (this.otherKeyParameter != null) {
            try {
                if (this.state == 1 || this.state == 3) {
                    this.engine.init(true, (CipherParameters)this.otherKeyParameter, (CipherParameters)this.key, (CipherParameters)iESWithCipherParameters);
                } else {
                    this.engine.init(false, (CipherParameters)this.key, (CipherParameters)this.otherKeyParameter, (CipherParameters)iESWithCipherParameters);
                }
                return this.engine.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", (Throwable)exception);
            }
        }
        if (this.state == 1 || this.state == 3) {
            ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
            eCKeyPairGenerator.init((KeyGenerationParameters)new ECKeyGenerationParameters(eCDomainParameters, this.random));
            boolean bl2 = this.engineSpec.getPointCompression();
            EphemeralKeyPairGenerator ephemeralKeyPairGenerator = new EphemeralKeyPairGenerator((AsymmetricCipherKeyPairGenerator)eCKeyPairGenerator, (KeyEncoder)new /* Unavailable Anonymous Inner Class!! */);
            try {
                this.engine.init(this.key, (CipherParameters)iESWithCipherParameters, ephemeralKeyPairGenerator);
                return this.engine.processBlock(byArray2, 0, byArray2.length);
            }
            catch (Exception exception) {
                throw new BadBlockException("unable to process block", (Throwable)exception);
            }
        }
        if (this.state == 2 || this.state == 4) {
            try {
                this.engine.init(this.key, (CipherParameters)iESWithCipherParameters, (KeyParser)new ECIESPublicKeyParser(eCDomainParameters));
                return this.engine.processBlock(byArray2, 0, byArray2.length);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new BadBlockException("unable to process block", (Throwable)invalidCipherTextException);
            }
        }
        throw new IllegalStateException("cipher not initialised");
    }

    public int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }
}

