/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dstu;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Null;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PrivateKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.sec.ECPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.DSTU4145NamedCurves;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ua.UAObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.SubjectPublicKeyInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X962Parameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ECParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9ObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dstu.BCDSTU4145PublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.EC5Util;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.ECUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.config.ProviderConfiguration;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPointEncoder;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.PKCS12BagAttributeCarrier;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.provider.BouncyCastleProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECNamedCurveSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECPrivateKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;

public class BCDSTU4145PrivateKey
implements ECPointEncoder,
macromedia.externals.org.bouncycastle_1_60_0_0.jce.interfaces.ECPrivateKey,
PKCS12BagAttributeCarrier,
java.security.interfaces.ECPrivateKey {
    static final long serialVersionUID = 7245981689601667138L;
    private String algorithm = "DSTU4145";
    private boolean withCompression;
    private transient BigInteger d;
    private transient ECParameterSpec ecSpec;
    private transient DERBitString publicKey;
    private transient PKCS12BagAttributeCarrierImpl attrCarrier = new PKCS12BagAttributeCarrierImpl();

    protected BCDSTU4145PrivateKey() {
    }

    public BCDSTU4145PrivateKey(java.security.interfaces.ECPrivateKey eCPrivateKey) {
        this.d = eCPrivateKey.getS();
        this.algorithm = eCPrivateKey.getAlgorithm();
        this.ecSpec = eCPrivateKey.getParams();
    }

    public BCDSTU4145PrivateKey(ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getD();
        if (eCPrivateKeySpec.getParams() != null) {
            ECCurve eCCurve = eCPrivateKeySpec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCCurve, (byte[])eCPrivateKeySpec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec((EllipticCurve)ellipticCurve, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)eCPrivateKeySpec.getParams());
        } else {
            this.ecSpec = null;
        }
    }

    public BCDSTU4145PrivateKey(java.security.spec.ECPrivateKeySpec eCPrivateKeySpec) {
        this.d = eCPrivateKeySpec.getS();
        this.ecSpec = eCPrivateKeySpec.getParams();
    }

    public BCDSTU4145PrivateKey(BCDSTU4145PrivateKey bCDSTU4145PrivateKey) {
        this.d = bCDSTU4145PrivateKey.d;
        this.ecSpec = bCDSTU4145PrivateKey.ecSpec;
        this.withCompression = bCDSTU4145PrivateKey.withCompression;
        this.attrCarrier = bCDSTU4145PrivateKey.attrCarrier;
        this.publicKey = bCDSTU4145PrivateKey.publicKey;
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCDSTU4145PublicKey bCDSTU4145PublicKey, ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            this.ecSpec = eCParameterSpec;
        }
        this.publicKey = this.getPublicKeyDetails(bCDSTU4145PublicKey);
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters, BCDSTU4145PublicKey bCDSTU4145PublicKey, macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec eCParameterSpec) {
        ECDomainParameters eCDomainParameters = eCPrivateKeyParameters.getParameters();
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        if (eCParameterSpec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH().intValue());
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCParameterSpec.getCurve(), (byte[])eCParameterSpec.getSeed());
            this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCParameterSpec.getG()), eCParameterSpec.getN(), eCParameterSpec.getH().intValue());
        }
        this.publicKey = this.getPublicKeyDetails(bCDSTU4145PublicKey);
    }

    public BCDSTU4145PrivateKey(String string, ECPrivateKeyParameters eCPrivateKeyParameters) {
        this.algorithm = string;
        this.d = eCPrivateKeyParameters.getD();
        this.ecSpec = null;
    }

    BCDSTU4145PrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.populateFromPrivKeyInfo(privateKeyInfo);
    }

    private void populateFromPrivKeyInfo(PrivateKeyInfo privateKeyInfo) throws IOException {
        Object object;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        X962Parameters x962Parameters = new X962Parameters((ASN1Primitive)privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        if (x962Parameters.isNamedCurve()) {
            aSN1ObjectIdentifier = ASN1ObjectIdentifier.getInstance((Object)x962Parameters.getParameters());
            object = ECUtil.getNamedCurveByOid((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
            if (object == null) {
                ECDomainParameters eCDomainParameters = DSTU4145NamedCurves.getByOID((ASN1ObjectIdentifier)aSN1ObjectIdentifier);
                EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)eCDomainParameters.getCurve(), (byte[])eCDomainParameters.getSeed());
                this.ecSpec = new ECNamedCurveSpec(aSN1ObjectIdentifier.getId(), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)eCDomainParameters.getG()), eCDomainParameters.getN(), eCDomainParameters.getH());
            } else {
                EllipticCurve ellipticCurve = EC5Util.convertCurve((ECCurve)object.getCurve(), (byte[])object.getSeed());
                this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName((ASN1ObjectIdentifier)aSN1ObjectIdentifier), ellipticCurve, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)object.getG()), object.getN(), object.getH());
            }
        } else if (x962Parameters.isImplicitlyCA()) {
            this.ecSpec = null;
        } else {
            aSN1ObjectIdentifier = X9ECParameters.getInstance((Object)x962Parameters.getParameters());
            object = EC5Util.convertCurve((ECCurve)aSN1ObjectIdentifier.getCurve(), (byte[])aSN1ObjectIdentifier.getSeed());
            this.ecSpec = new ECParameterSpec((EllipticCurve)object, EC5Util.convertPoint((macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint)aSN1ObjectIdentifier.getG()), aSN1ObjectIdentifier.getN(), aSN1ObjectIdentifier.getH().intValue());
        }
        aSN1ObjectIdentifier = privateKeyInfo.parsePrivateKey();
        if (aSN1ObjectIdentifier instanceof ASN1Integer) {
            object = ASN1Integer.getInstance((Object)aSN1ObjectIdentifier);
            this.d = object.getValue();
        } else {
            object = ECPrivateKey.getInstance((Object)aSN1ObjectIdentifier);
            this.d = object.getKey();
            this.publicKey = object.getPublicKey();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        ECPrivateKey eCPrivateKey;
        int n2;
        X962Parameters x962Parameters;
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (this.ecSpec instanceof ECNamedCurveSpec) {
            aSN1ObjectIdentifier = ECUtil.getNamedCurveOid((String)((ECNamedCurveSpec)this.ecSpec).getName());
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.ecSpec).getName());
            }
            x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
            n2 = ECUtil.getOrderBitLength((ProviderConfiguration)BouncyCastleProvider.CONFIGURATION, (BigInteger)this.ecSpec.getOrder(), (BigInteger)this.getS());
        } else if (this.ecSpec == null) {
            x962Parameters = new X962Parameters((ASN1Null)DERNull.INSTANCE);
            n2 = ECUtil.getOrderBitLength((ProviderConfiguration)BouncyCastleProvider.CONFIGURATION, null, (BigInteger)this.getS());
        } else {
            aSN1ObjectIdentifier = EC5Util.convertCurve((EllipticCurve)this.ecSpec.getCurve());
            eCPrivateKey = new X9ECParameters((ECCurve)aSN1ObjectIdentifier, EC5Util.convertPoint((ECCurve)aSN1ObjectIdentifier, (ECPoint)this.ecSpec.getGenerator(), (boolean)this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
            x962Parameters = new X962Parameters((X9ECParameters)eCPrivateKey);
            n2 = ECUtil.getOrderBitLength((ProviderConfiguration)BouncyCastleProvider.CONFIGURATION, (BigInteger)this.ecSpec.getOrder(), (BigInteger)this.getS());
        }
        eCPrivateKey = this.publicKey != null ? new ECPrivateKey(n2, this.getS(), this.publicKey, (ASN1Encodable)x962Parameters) : new ECPrivateKey(n2, this.getS(), (ASN1Encodable)x962Parameters);
        try {
            aSN1ObjectIdentifier = this.algorithm.equals("DSTU4145") ? new PrivateKeyInfo(new AlgorithmIdentifier(UAObjectIdentifiers.dstu4145be, (ASN1Encodable)x962Parameters.toASN1Primitive()), (ASN1Encodable)eCPrivateKey.toASN1Primitive()) : new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)x962Parameters.toASN1Primitive()), (ASN1Encodable)eCPrivateKey.toASN1Primitive());
            return aSN1ObjectIdentifier.getEncoded("DER");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
    }

    macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec((ECParameterSpec)this.ecSpec, (boolean)this.withCompression);
        }
        return BouncyCastleProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    @Override
    public BigInteger getS() {
        return this.d;
    }

    public BigInteger getD() {
        return this.d;
    }

    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }

    public void setPointFormat(String string) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(string);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BCDSTU4145PrivateKey)) {
            return false;
        }
        BCDSTU4145PrivateKey bCDSTU4145PrivateKey = (BCDSTU4145PrivateKey)object;
        return this.getD().equals(bCDSTU4145PrivateKey.getD()) && this.engineGetSpec().equals((Object)bCDSTU4145PrivateKey.engineGetSpec());
    }

    public int hashCode() {
        return this.getD().hashCode() ^ this.engineGetSpec().hashCode();
    }

    public String toString() {
        return ECUtil.privateKeyToString((String)this.algorithm, (BigInteger)this.d, (macromedia.externals.org.bouncycastle_1_60_0_0.jce.spec.ECParameterSpec)this.engineGetSpec());
    }

    private DERBitString getPublicKeyDetails(BCDSTU4145PublicKey bCDSTU4145PublicKey) {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])bCDSTU4145PublicKey.getEncoded()));
            return subjectPublicKeyInfo.getPublicKeyData();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.populateFromPrivKeyInfo(PrivateKeyInfo.getInstance((Object)ASN1Primitive.fromByteArray((byte[])byArray)));
        this.attrCarrier = new PKCS12BagAttributeCarrierImpl();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

