/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dh;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BasicAgreement;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DerivationFunction;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.DHUnifiedAgreement;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHMQVPrivateParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHMQVPublicParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHUPrivateParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHUPublicParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.DHDomainParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.DHUParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.MQVParameterSpec;
import macromedia.externals.org.bouncycastle_1_60_0_0.jcajce.spec.UserKeyingMaterialSpec;

/*
 * Exception performing whole class analysis ignored.
 */
public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private final DHUnifiedAgreement unifiedAgreement;
    private final BasicAgreement mqvAgreement;
    private DHUParameterSpec dheParameters;
    private MQVParameterSpec mqvParameters;
    private BigInteger x;
    private BigInteger p;
    private BigInteger g;
    private byte[] result;

    public KeyAgreementSpi() {
        this("Diffie-Hellman", null);
    }

    public KeyAgreementSpi(String string, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.unifiedAgreement = null;
        this.mqvAgreement = null;
    }

    public KeyAgreementSpi(String string, DHUnifiedAgreement dHUnifiedAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.unifiedAgreement = dHUnifiedAgreement;
        this.mqvAgreement = null;
    }

    public KeyAgreementSpi(String string, BasicAgreement basicAgreement, DerivationFunction derivationFunction) {
        super(string, derivationFunction);
        this.unifiedAgreement = null;
        this.mqvAgreement = basicAgreement;
    }

    protected byte[] bigIntToBytes(BigInteger bigInteger) {
        int n2 = (this.p.bitLength() + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == n2) {
            return byArray;
        }
        if (byArray[0] == 0 && byArray.length == n2 + 1) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, byArray3.length - byArray.length, byArray.length);
        return byArray3;
    }

    protected Key engineDoPhase(Key key, boolean bl2) throws InvalidKeyException, IllegalStateException {
        if (this.x == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("DHKeyAgreement doPhase requires DHPublicKey");
        }
        DHPublicKey dHPublicKey = (DHPublicKey)key;
        if (!dHPublicKey.getParams().getG().equals(this.g) || !dHPublicKey.getParams().getP().equals(this.p)) {
            throw new InvalidKeyException("DHPublicKey not for this KeyAgreement!");
        }
        BigInteger bigInteger = ((DHPublicKey)key).getY();
        if (bigInteger == null || bigInteger.compareTo(TWO) < 0 || bigInteger.compareTo(this.p.subtract(ONE)) >= 0) {
            throw new InvalidKeyException("Invalid DH PublicKey");
        }
        if (this.unifiedAgreement != null) {
            if (!bl2) {
                throw new IllegalStateException("unified Diffie-Hellman can use only two key pairs");
            }
            DHPublicKeyParameters dHPublicKeyParameters = this.generatePublicKeyParameter((PublicKey)key);
            DHPublicKeyParameters dHPublicKeyParameters2 = this.generatePublicKeyParameter(this.dheParameters.getOtherPartyEphemeralKey());
            DHUPublicParameters dHUPublicParameters = new DHUPublicParameters(dHPublicKeyParameters, dHPublicKeyParameters2);
            this.result = this.unifiedAgreement.calculateAgreement((CipherParameters)dHUPublicParameters);
            return null;
        }
        if (this.mqvAgreement != null) {
            if (!bl2) {
                throw new IllegalStateException("MQV Diffie-Hellman can use only two key pairs");
            }
            DHPublicKeyParameters dHPublicKeyParameters = this.generatePublicKeyParameter((PublicKey)key);
            DHPublicKeyParameters dHPublicKeyParameters3 = this.generatePublicKeyParameter(this.mqvParameters.getOtherPartyEphemeralKey());
            DHMQVPublicParameters dHMQVPublicParameters = new DHMQVPublicParameters(dHPublicKeyParameters, dHPublicKeyParameters3);
            this.result = this.bigIntToBytes(this.mqvAgreement.calculateAgreement((CipherParameters)dHMQVPublicParameters));
            return null;
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.x, this.p);
        if (bigInteger2.compareTo(ONE) == 0) {
            throw new InvalidKeyException("Shared key can't be 1");
        }
        this.result = this.bigIntToBytes(bigInteger2);
        if (bl2) {
            return null;
        }
        return new BCDHPublicKey(bigInteger2, dHPublicKey.getParams());
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (this.x == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        return super.engineGenerateSecret();
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (this.x == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        return super.engineGenerateSecret(byArray, n2);
    }

    protected SecretKey engineGenerateSecret(String string) throws NoSuchAlgorithmException {
        if (this.x == null) {
            throw new IllegalStateException("Diffie-Hellman not initialised.");
        }
        if (string.equals("TlsPremasterSecret")) {
            return new SecretKeySpec(KeyAgreementSpi.trimZeroes((byte[])this.result), string);
        }
        return super.engineGenerateSecret(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("DHKeyAgreement requires DHPrivateKey for initialisation");
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof DHParameterSpec) {
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
                this.p = dHParameterSpec.getP();
                this.g = dHParameterSpec.getG();
                this.dheParameters = null;
                this.ukmParameters = null;
            } else if (algorithmParameterSpec instanceof DHUParameterSpec) {
                if (this.unifiedAgreement == null) {
                    throw new InvalidAlgorithmParameterException("agreement algorithm not DHU based");
                }
                this.p = dHPrivateKey.getParams().getP();
                this.g = dHPrivateKey.getParams().getG();
                this.dheParameters = (DHUParameterSpec)algorithmParameterSpec;
                this.ukmParameters = ((DHUParameterSpec)algorithmParameterSpec).getUserKeyingMaterial();
                if (this.dheParameters.getEphemeralPublicKey() != null) {
                    this.unifiedAgreement.init((CipherParameters)new DHUPrivateParameters(this.generatePrivateKeyParameter((PrivateKey)dHPrivateKey), this.generatePrivateKeyParameter(this.dheParameters.getEphemeralPrivateKey()), this.generatePublicKeyParameter(this.dheParameters.getEphemeralPublicKey())));
                } else {
                    this.unifiedAgreement.init((CipherParameters)new DHUPrivateParameters(this.generatePrivateKeyParameter((PrivateKey)dHPrivateKey), this.generatePrivateKeyParameter(this.dheParameters.getEphemeralPrivateKey())));
                }
            } else if (algorithmParameterSpec instanceof MQVParameterSpec) {
                if (this.mqvAgreement == null) {
                    throw new InvalidAlgorithmParameterException("agreement algorithm not MQV based");
                }
                this.p = dHPrivateKey.getParams().getP();
                this.g = dHPrivateKey.getParams().getG();
                this.mqvParameters = (MQVParameterSpec)algorithmParameterSpec;
                this.ukmParameters = ((MQVParameterSpec)algorithmParameterSpec).getUserKeyingMaterial();
                if (this.mqvParameters.getEphemeralPublicKey() != null) {
                    this.mqvAgreement.init((CipherParameters)new DHMQVPrivateParameters(this.generatePrivateKeyParameter((PrivateKey)dHPrivateKey), this.generatePrivateKeyParameter(this.mqvParameters.getEphemeralPrivateKey()), this.generatePublicKeyParameter(this.mqvParameters.getEphemeralPublicKey())));
                } else {
                    this.mqvAgreement.init((CipherParameters)new DHMQVPrivateParameters(this.generatePrivateKeyParameter((PrivateKey)dHPrivateKey), this.generatePrivateKeyParameter(this.mqvParameters.getEphemeralPrivateKey())));
                }
            } else {
                if (!(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) throw new InvalidAlgorithmParameterException("DHKeyAgreement only accepts DHParameterSpec");
                if (this.kdf == null) {
                    throw new InvalidAlgorithmParameterException("no KDF specified for UserKeyingMaterialSpec");
                }
                this.p = dHPrivateKey.getParams().getP();
                this.g = dHPrivateKey.getParams().getG();
                this.dheParameters = null;
                this.ukmParameters = ((UserKeyingMaterialSpec)algorithmParameterSpec).getUserKeyingMaterial();
            }
        } else {
            this.p = dHPrivateKey.getParams().getP();
            this.g = dHPrivateKey.getParams().getG();
        }
        this.x = dHPrivateKey.getX();
        this.result = this.bigIntToBytes(this.x);
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("DHKeyAgreement requires DHPrivateKey");
        }
        DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
        this.p = dHPrivateKey.getParams().getP();
        this.g = dHPrivateKey.getParams().getG();
        this.x = dHPrivateKey.getX();
        this.result = this.bigIntToBytes(this.x);
    }

    protected byte[] calcSecret() {
        return this.result;
    }

    private DHPrivateKeyParameters generatePrivateKeyParameter(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof DHPrivateKey) {
            if (privateKey instanceof BCDHPrivateKey) {
                return ((BCDHPrivateKey)privateKey).engineGetKeyParameters();
            }
            DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
            DHParameterSpec dHParameterSpec = dHPrivateKey.getParams();
            return new DHPrivateKeyParameters(dHPrivateKey.getX(), new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
        }
        throw new InvalidKeyException("private key not a DHPrivateKey");
    }

    private DHPublicKeyParameters generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof DHPublicKey) {
            if (publicKey instanceof BCDHPublicKey) {
                return ((BCDHPublicKey)publicKey).engineGetKeyParameters();
            }
            DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
            DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
            if (dHParameterSpec instanceof DHDomainParameterSpec) {
                return new DHPublicKeyParameters(dHPublicKey.getY(), ((DHDomainParameterSpec)dHParameterSpec).getDomainParameters());
            }
            return new DHPublicKeyParameters(dHPublicKey.getY(), new DHParameters(dHParameterSpec.getP(), dHParameterSpec.getG(), null, dHParameterSpec.getL()));
        }
        throw new InvalidKeyException("public key not a DHPublicKey");
    }
}

