/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DatagramTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;

public class UDPTransport
implements DatagramTransport {
    protected static final int MIN_IP_OVERHEAD = 20;
    protected static final int MAX_IP_OVERHEAD = 84;
    protected static final int UDP_OVERHEAD = 8;
    protected final DatagramSocket socket;
    protected final int receiveLimit;
    protected final int sendLimit;

    public UDPTransport(DatagramSocket datagramSocket, int n2) throws IOException {
        if (!datagramSocket.isBound() || !datagramSocket.isConnected()) {
            throw new IllegalArgumentException("'socket' must be bound and connected");
        }
        this.socket = datagramSocket;
        this.receiveLimit = n2 - 20 - 8;
        this.sendLimit = n2 - 84 - 8;
    }

    public int getReceiveLimit() {
        return this.receiveLimit;
    }

    public int getSendLimit() {
        return this.sendLimit;
    }

    public int receive(byte[] byArray, int n2, int n3, int n4) throws IOException {
        this.socket.setSoTimeout(n4);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n2, n3);
        this.socket.receive(datagramPacket);
        return datagramPacket.getLength();
    }

    public void send(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 > this.getSendLimit()) {
            throw new TlsFatalAlert(80);
        }
        DatagramPacket datagramPacket = new DatagramPacket(byArray, n2, n3);
        this.socket.send(datagramPacket);
    }

    public void close() throws IOException {
        this.socket.close();
    }
}

