/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Signer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.NullDigest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.encodings.PKCS1Encoding;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.RSABlindedEngine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers.GenericSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers.RSADigestSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.AbstractTlsSigner;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CombinedHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.SignatureAndHashAlgorithm;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class TlsRSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, true, (CipherParameters)new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.context.getSecureRandom()));
        signer.update(byArray, 0, byArray.length);
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(SignatureAndHashAlgorithm signatureAndHashAlgorithm, byte[] byArray, AsymmetricKeyParameter asymmetricKeyParameter, byte[] byArray2) throws CryptoException {
        Signer signer = this.makeSigner(signatureAndHashAlgorithm, true, false, (CipherParameters)asymmetricKeyParameter);
        signer.update(byArray2, 0, byArray2.length);
        return signer.verifySignature(byArray);
    }

    public Signer createSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, true, (CipherParameters)new ParametersWithRandom((CipherParameters)asymmetricKeyParameter, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(SignatureAndHashAlgorithm signatureAndHashAlgorithm, AsymmetricKeyParameter asymmetricKeyParameter) {
        return this.makeSigner(signatureAndHashAlgorithm, false, false, (CipherParameters)asymmetricKeyParameter);
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter asymmetricKeyParameter) {
        return asymmetricKeyParameter instanceof RSAKeyParameters && !asymmetricKeyParameter.isPrivate();
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm signatureAndHashAlgorithm, boolean bl2, boolean bl3, CipherParameters cipherParameters) {
        if (signatureAndHashAlgorithm != null != TlsUtils.isTLSv12((TlsContext)this.context)) {
            throw new IllegalStateException();
        }
        if (signatureAndHashAlgorithm != null && signatureAndHashAlgorithm.getSignature() != 1) {
            throw new IllegalStateException();
        }
        Object object = bl2 ? new NullDigest() : (signatureAndHashAlgorithm == null ? new CombinedHash() : TlsUtils.createHash((short)signatureAndHashAlgorithm.getHash()));
        Object object2 = signatureAndHashAlgorithm != null ? new RSADigestSigner((Digest)object, TlsUtils.getOIDForHashAlgorithm((short)signatureAndHashAlgorithm.getHash())) : new GenericSigner(this.createRSAImpl(), (Digest)object);
        object2.init(bl3, cipherParameters);
        return object2;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
    }
}

