/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateStatusRequest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.HeartbeatExtension;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ServerNameList;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;

/*
 * Exception performing whole class analysis ignored.
 */
public class TlsExtensionsUtils {
    public static final Integer EXT_encrypt_then_mac = Integers.valueOf((int)22);
    public static final Integer EXT_extended_master_secret = Integers.valueOf((int)23);
    public static final Integer EXT_heartbeat = Integers.valueOf((int)15);
    public static final Integer EXT_max_fragment_length = Integers.valueOf((int)1);
    public static final Integer EXT_padding = Integers.valueOf((int)21);
    public static final Integer EXT_server_name = Integers.valueOf((int)0);
    public static final Integer EXT_status_request = Integers.valueOf((int)5);
    public static final Integer EXT_truncated_hmac = Integers.valueOf((int)4);

    public static Hashtable ensureExtensionsInitialised(Hashtable hashtable) {
        return hashtable == null ? new Hashtable() : hashtable;
    }

    public static void addEncryptThenMACExtension(Hashtable hashtable) {
        hashtable.put(EXT_encrypt_then_mac, TlsExtensionsUtils.createEncryptThenMACExtension());
    }

    public static void addExtendedMasterSecretExtension(Hashtable hashtable) {
        hashtable.put(EXT_extended_master_secret, TlsExtensionsUtils.createExtendedMasterSecretExtension());
    }

    public static void addHeartbeatExtension(Hashtable hashtable, HeartbeatExtension heartbeatExtension) throws IOException {
        hashtable.put(EXT_heartbeat, TlsExtensionsUtils.createHeartbeatExtension((HeartbeatExtension)heartbeatExtension));
    }

    public static void addMaxFragmentLengthExtension(Hashtable hashtable, short s2) throws IOException {
        hashtable.put(EXT_max_fragment_length, TlsExtensionsUtils.createMaxFragmentLengthExtension((short)s2));
    }

    public static void addPaddingExtension(Hashtable hashtable, int n2) throws IOException {
        hashtable.put(EXT_padding, TlsExtensionsUtils.createPaddingExtension((int)n2));
    }

    public static void addServerNameExtension(Hashtable hashtable, ServerNameList serverNameList) throws IOException {
        hashtable.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtension((ServerNameList)serverNameList));
    }

    public static void addStatusRequestExtension(Hashtable hashtable, CertificateStatusRequest certificateStatusRequest) throws IOException {
        hashtable.put(EXT_status_request, TlsExtensionsUtils.createStatusRequestExtension((CertificateStatusRequest)certificateStatusRequest));
    }

    public static void addTruncatedHMacExtension(Hashtable hashtable) {
        hashtable.put(EXT_truncated_hmac, TlsExtensionsUtils.createTruncatedHMacExtension());
    }

    public static HeartbeatExtension getHeartbeatExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_heartbeat);
        return byArray == null ? null : TlsExtensionsUtils.readHeartbeatExtension((byte[])byArray);
    }

    public static short getMaxFragmentLengthExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_max_fragment_length);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readMaxFragmentLengthExtension((byte[])byArray);
    }

    public static int getPaddingExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_padding);
        return byArray == null ? -1 : TlsExtensionsUtils.readPaddingExtension((byte[])byArray);
    }

    public static ServerNameList getServerNameExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_server_name);
        return byArray == null ? null : TlsExtensionsUtils.readServerNameExtension((byte[])byArray);
    }

    public static CertificateStatusRequest getStatusRequestExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_status_request);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestExtension((byte[])byArray);
    }

    public static boolean hasEncryptThenMACExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_encrypt_then_mac);
        return byArray == null ? false : TlsExtensionsUtils.readEncryptThenMACExtension((byte[])byArray);
    }

    public static boolean hasExtendedMasterSecretExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_extended_master_secret);
        return byArray == null ? false : TlsExtensionsUtils.readExtendedMasterSecretExtension((byte[])byArray);
    }

    public static boolean hasTruncatedHMacExtension(Hashtable hashtable) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData((Hashtable)hashtable, (Integer)EXT_truncated_hmac);
        return byArray == null ? false : TlsExtensionsUtils.readTruncatedHMacExtension((byte[])byArray);
    }

    public static byte[] createEmptyExtensionData() {
        return TlsUtils.EMPTY_BYTES;
    }

    public static byte[] createEncryptThenMACExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createExtendedMasterSecretExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createHeartbeatExtension(HeartbeatExtension heartbeatExtension) throws IOException {
        if (heartbeatExtension == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        heartbeatExtension.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createMaxFragmentLengthExtension(short s2) throws IOException {
        TlsUtils.checkUint8((short)s2);
        byte[] byArray = new byte[1];
        TlsUtils.writeUint8((short)s2, (byte[])byArray, (int)0);
        return byArray;
    }

    public static byte[] createPaddingExtension(int n2) throws IOException {
        TlsUtils.checkUint16((int)n2);
        return new byte[n2];
    }

    public static byte[] createServerNameExtension(ServerNameList serverNameList) throws IOException {
        if (serverNameList == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        serverNameList.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createStatusRequestExtension(CertificateStatusRequest certificateStatusRequest) throws IOException {
        if (certificateStatusRequest == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateStatusRequest.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createTruncatedHMacExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    private static boolean readEmptyExtensionData(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(47);
        }
        return true;
    }

    public static boolean readEncryptThenMACExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData((byte[])byArray);
    }

    public static boolean readExtendedMasterSecretExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData((byte[])byArray);
    }

    public static HeartbeatExtension readHeartbeatExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        HeartbeatExtension heartbeatExtension = HeartbeatExtension.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        return heartbeatExtension;
    }

    public static short readMaxFragmentLengthExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 1) {
            throw new TlsFatalAlert(50);
        }
        return TlsUtils.readUint8((byte[])byArray, (int)0);
    }

    public static int readPaddingExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) continue;
            throw new TlsFatalAlert(47);
        }
        return byArray.length;
    }

    public static ServerNameList readServerNameExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ServerNameList serverNameList = ServerNameList.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        return serverNameList;
    }

    public static CertificateStatusRequest readStatusRequestExtension(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateStatusRequest certificateStatusRequest = CertificateStatusRequest.parse((InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        return certificateStatusRequest;
    }

    public static boolean readTruncatedHMacExtension(byte[] byArray) throws IOException {
        return TlsExtensionsUtils.readEmptyExtensionData((byte[])byArray);
    }
}

