/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class SignatureAndHashAlgorithm {
    protected short hash;
    protected short signature;

    public SignatureAndHashAlgorithm(short s2, short s3) {
        if (!TlsUtils.isValidUint8((short)s2)) {
            throw new IllegalArgumentException("'hash' should be a uint8");
        }
        if (!TlsUtils.isValidUint8((short)s3)) {
            throw new IllegalArgumentException("'signature' should be a uint8");
        }
        if (s3 == 0) {
            throw new IllegalArgumentException("'signature' MUST NOT be \"anonymous\"");
        }
        this.hash = s2;
        this.signature = s3;
    }

    public short getHash() {
        return this.hash;
    }

    public short getSignature() {
        return this.signature;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SignatureAndHashAlgorithm)) {
            return false;
        }
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = (SignatureAndHashAlgorithm)object;
        return signatureAndHashAlgorithm.getHash() == this.getHash() && signatureAndHashAlgorithm.getSignature() == this.getSignature();
    }

    public int hashCode() {
        return this.getHash() << 16 | this.getSignature();
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8((short)this.getHash(), (OutputStream)outputStream);
        TlsUtils.writeUint8((short)this.getSignature(), (OutputStream)outputStream);
    }

    public static SignatureAndHashAlgorithm parse(InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8((InputStream)inputStream);
        short s3 = TlsUtils.readUint8((InputStream)inputStream);
        return new SignatureAndHashAlgorithm(s2, s3);
    }
}

