/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public final class SessionParameters {
    private int cipherSuite;
    private short compressionAlgorithm;
    private byte[] masterSecret;
    private Certificate peerCertificate;
    private byte[] pskIdentity = null;
    private byte[] srpIdentity = null;
    private byte[] encodedServerExtensions;

    private SessionParameters(int n2, short s2, byte[] byArray, Certificate certificate, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.cipherSuite = n2;
        this.compressionAlgorithm = s2;
        this.masterSecret = Arrays.clone((byte[])byArray);
        this.peerCertificate = certificate;
        this.pskIdentity = Arrays.clone((byte[])byArray2);
        this.srpIdentity = Arrays.clone((byte[])byArray3);
        this.encodedServerExtensions = byArray4;
    }

    public void clear() {
        if (this.masterSecret != null) {
            Arrays.fill((byte[])this.masterSecret, (byte)0);
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.cipherSuite, this.compressionAlgorithm, this.masterSecret, this.peerCertificate, this.pskIdentity, this.srpIdentity, this.encodedServerExtensions);
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public short getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }

    public Certificate getPeerCertificate() {
        return this.peerCertificate;
    }

    public byte[] getPskIdentity() {
        return this.pskIdentity;
    }

    public byte[] getPSKIdentity() {
        return this.pskIdentity;
    }

    public byte[] getSRPIdentity() {
        return this.srpIdentity;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.encodedServerExtensions == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.encodedServerExtensions);
        return TlsProtocol.readExtensions((ByteArrayInputStream)byteArrayInputStream);
    }
}

