/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.AbstractTlsClient;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DefaultTlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DefaultTlsSRPGroupVerifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsAuthentication;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsExtensionsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPGroupVerifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPKeyExchange;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsSRPUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class SRPTlsClient
extends AbstractTlsClient {
    protected TlsSRPGroupVerifier groupVerifier;
    protected byte[] identity;
    protected byte[] password;

    public SRPTlsClient(byte[] byArray, byte[] byArray2) {
        this((TlsCipherFactory)new DefaultTlsCipherFactory(), (TlsSRPGroupVerifier)new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, byte[] byArray, byte[] byArray2) {
        this(tlsCipherFactory, (TlsSRPGroupVerifier)new DefaultTlsSRPGroupVerifier(), byArray, byArray2);
    }

    public SRPTlsClient(TlsCipherFactory tlsCipherFactory, TlsSRPGroupVerifier tlsSRPGroupVerifier, byte[] byArray, byte[] byArray2) {
        super(tlsCipherFactory);
        this.groupVerifier = tlsSRPGroupVerifier;
        this.identity = Arrays.clone((byte[])byArray);
        this.password = Arrays.clone((byte[])byArray2);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    public int[] getCipherSuites() {
        return new int[]{49182};
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)super.getClientExtensions());
        TlsSRPUtils.addSRPExtension((Hashtable)hashtable, (byte[])this.identity);
        return hashtable;
    }

    public void processServerExtensions(Hashtable hashtable) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData((Hashtable)hashtable, (Integer)TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(hashtable);
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm((int)this.selectedCipherSuite);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int n2) {
        return new TlsSRPKeyExchange(n2, this.supportedSignatureAlgorithms, this.groupVerifier, this.identity, this.password);
    }
}

