/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ocsp.ResponderID;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.io.Streams;

public class OCSPStatusRequest {
    protected Vector responderIDList;
    protected Extensions requestExtensions;

    public OCSPStatusRequest(Vector vector, Extensions extensions) {
        this.responderIDList = vector;
        this.requestExtensions = extensions;
    }

    public Vector getResponderIDList() {
        return this.responderIDList;
    }

    public Extensions getRequestExtensions() {
        return this.requestExtensions;
    }

    public void encode(OutputStream outputStream) throws IOException {
        Object object;
        if (this.responderIDList == null || this.responderIDList.isEmpty()) {
            TlsUtils.writeUint16((int)0, (OutputStream)outputStream);
        } else {
            object = new ByteArrayOutputStream();
            for (int i2 = 0; i2 < this.responderIDList.size(); ++i2) {
                ResponderID responderID = (ResponderID)this.responderIDList.elementAt(i2);
                byte[] byArray = responderID.getEncoded("DER");
                TlsUtils.writeOpaque16((byte[])byArray, (OutputStream)object);
            }
            TlsUtils.checkUint16((int)((ByteArrayOutputStream)object).size());
            TlsUtils.writeUint16((int)((ByteArrayOutputStream)object).size(), (OutputStream)outputStream);
            Streams.writeBufTo((ByteArrayOutputStream)object, (OutputStream)outputStream);
        }
        if (this.requestExtensions == null) {
            TlsUtils.writeUint16((int)0, (OutputStream)outputStream);
        } else {
            object = this.requestExtensions.getEncoded("DER");
            TlsUtils.checkUint16((int)((Object)object).length);
            TlsUtils.writeUint16((int)((Object)object).length, (OutputStream)outputStream);
            outputStream.write((byte[])object);
        }
    }

    public static OCSPStatusRequest parse(InputStream inputStream) throws IOException {
        Object object;
        Vector<ResponderID> vector = new Vector<ResponderID>();
        int n2 = TlsUtils.readUint16((InputStream)inputStream);
        if (n2 > 0) {
            byte[] byArray = TlsUtils.readFully((int)n2, (InputStream)inputStream);
            object = new ByteArrayInputStream(byArray);
            do {
                byte[] byArray2 = TlsUtils.readOpaque16((InputStream)object);
                ResponderID responderID = ResponderID.getInstance((Object)TlsUtils.readDERObject((byte[])byArray2));
                vector.addElement(responderID);
            } while (((ByteArrayInputStream)object).available() > 0);
        }
        Extensions extensions = null;
        int n3 = TlsUtils.readUint16((InputStream)inputStream);
        if (n3 > 0) {
            object = TlsUtils.readFully((int)n3, (InputStream)inputStream);
            extensions = Extensions.getInstance((Object)TlsUtils.readDERObject((byte[])object));
        }
        return new OCSPStatusRequest(vector, extensions);
    }
}

