/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.util.Enumeration;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CombinedHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DigestInputBuffer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.HashAlgorithm;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsHandshakeHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Shorts;

class DeferredHash
implements TlsHandshakeHash {
    protected static final int BUFFERING_HASH_LIMIT = 4;
    protected TlsContext context;
    private DigestInputBuffer buf;
    private Hashtable hashes;
    private Short prfHashAlgorithm;

    DeferredHash() {
        this.buf = new DigestInputBuffer();
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = null;
    }

    private DeferredHash(Short s2, Digest digest) {
        this.buf = null;
        this.hashes = new Hashtable();
        this.prfHashAlgorithm = s2;
        this.hashes.put(s2, digest);
    }

    public void init(TlsContext tlsContext) {
        this.context = tlsContext;
    }

    public TlsHandshakeHash notifyPRFDetermined() {
        int n2 = this.context.getSecurityParameters().getPrfAlgorithm();
        if (n2 == 0) {
            CombinedHash combinedHash = new CombinedHash();
            combinedHash.init(this.context);
            this.buf.updateDigest((Digest)combinedHash);
            return combinedHash.notifyPRFDetermined();
        }
        this.prfHashAlgorithm = Shorts.valueOf((short)TlsUtils.getHashAlgorithmForPRFAlgorithm((int)n2));
        this.checkTrackingHash(this.prfHashAlgorithm);
        return this;
    }

    public void trackHashAlgorithm(short s2) {
        if (this.buf == null) {
            throw new IllegalStateException("Too late to track more hash algorithms");
        }
        this.checkTrackingHash(Shorts.valueOf((short)s2));
    }

    public void sealHashAlgorithms() {
        this.checkStopBuffering();
    }

    public TlsHandshakeHash stopTracking() {
        Digest digest = TlsUtils.cloneHash((short)this.prfHashAlgorithm, (Digest)((Digest)this.hashes.get(this.prfHashAlgorithm)));
        if (this.buf != null) {
            this.buf.updateDigest(digest);
        }
        DeferredHash deferredHash = new DeferredHash(this.prfHashAlgorithm, digest);
        deferredHash.init(this.context);
        return deferredHash;
    }

    public Digest forkPRFHash() {
        this.checkStopBuffering();
        if (this.buf != null) {
            Digest digest = TlsUtils.createHash((short)this.prfHashAlgorithm);
            this.buf.updateDigest(digest);
            return digest;
        }
        return TlsUtils.cloneHash((short)this.prfHashAlgorithm, (Digest)((Digest)this.hashes.get(this.prfHashAlgorithm)));
    }

    public byte[] getFinalHash(short s2) {
        Digest digest = (Digest)this.hashes.get(Shorts.valueOf((short)s2));
        if (digest == null) {
            throw new IllegalStateException("HashAlgorithm." + HashAlgorithm.getText((short)s2) + " is not being tracked");
        }
        digest = TlsUtils.cloneHash((short)s2, (Digest)digest);
        if (this.buf != null) {
            this.buf.updateDigest(digest);
        }
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    public String getAlgorithmName() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    public int getDigestSize() {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    public void update(byte by2) {
        if (this.buf != null) {
            this.buf.write((int)by2);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            Digest digest = (Digest)enumeration.nextElement();
            digest.update(by2);
        }
    }

    public void update(byte[] byArray, int n2, int n3) {
        if (this.buf != null) {
            this.buf.write(byArray, n2, n3);
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            Digest digest = (Digest)enumeration.nextElement();
            digest.update(byArray, n2, n3);
        }
    }

    public int doFinal(byte[] byArray, int n2) {
        throw new IllegalStateException("Use fork() to get a definite Digest");
    }

    public void reset() {
        if (this.buf != null) {
            this.buf.reset();
            return;
        }
        Enumeration enumeration = this.hashes.elements();
        while (enumeration.hasMoreElements()) {
            Digest digest = (Digest)enumeration.nextElement();
            digest.reset();
        }
    }

    protected void checkStopBuffering() {
        if (this.buf != null && this.hashes.size() <= 4) {
            Enumeration enumeration = this.hashes.elements();
            while (enumeration.hasMoreElements()) {
                Digest digest = (Digest)enumeration.nextElement();
                this.buf.updateDigest(digest);
            }
            this.buf = null;
        }
    }

    protected void checkTrackingHash(Short s2) {
        if (!this.hashes.containsKey(s2)) {
            Digest digest = TlsUtils.createHash((short)s2);
            this.hashes.put(s2, digest);
        }
    }
}

