/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSRecordLayer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DatagramTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;

public class DTLSTransport
implements DatagramTransport {
    private final DTLSRecordLayer recordLayer;

    DTLSTransport(DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
    }

    public int getReceiveLimit() throws IOException {
        return this.recordLayer.getReceiveLimit();
    }

    public int getSendLimit() throws IOException {
        return this.recordLayer.getSendLimit();
    }

    public int receive(byte[] byArray, int n2, int n3, int n4) throws IOException {
        try {
            return this.recordLayer.receive(byArray, n2, n3, n4);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    public void send(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.recordLayer.send(byArray, n2, n3);
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.recordLayer.fail(tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.recordLayer.fail((short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.recordLayer.fail((short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
    }

    public void close() throws IOException {
        this.recordLayer.close();
    }
}

