/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSReassembler;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSRecordLayer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSReliableHandshake;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DeferredHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsHandshakeHash;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;

/*
 * Exception performing whole class analysis ignored.
 */
class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 16;
    private static final int MESSAGE_HEADER_LENGTH = 12;
    private DTLSRecordLayer recordLayer;
    private TlsHandshakeHash handshakeHash;
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext tlsContext, DTLSRecordLayer dTLSRecordLayer) {
        this.recordLayer = dTLSRecordLayer;
        this.handshakeHash = new DeferredHash();
        this.handshakeHash.init(tlsContext);
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash tlsHandshakeHash = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return tlsHandshakeHash;
    }

    void sendMessage(short s2, byte[] byArray) throws IOException {
        TlsUtils.checkUint24((int)byArray.length);
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.message_seq++, s2, byArray, null);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    byte[] receiveMessageBody(short s2) throws IOException {
        Message message = this.receiveMessage();
        if (message.getType() != s2) {
            throw new TlsFatalAlert(10);
        }
        return message.getBody();
    }

    Message receiveMessage() throws IOException {
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight(new Hashtable());
        }
        byte[] byArray = null;
        int n2 = 1000;
        while (true) {
            try {
                while (true) {
                    int n3;
                    Message message;
                    if ((message = this.getPendingMessage()) != null) {
                        return message;
                    }
                    int n4 = this.recordLayer.getReceiveLimit();
                    if (byArray == null || byArray.length < n4) {
                        byArray = new byte[n4];
                    }
                    if ((n3 = this.recordLayer.receive(byArray, 0, n4, n2)) >= 0) {
                        boolean bl2 = this.processRecord(16, this.recordLayer.getReadEpoch(), byArray, 0, n3);
                        if (!bl2) continue;
                        n2 = this.backOff(n2);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.resendOutboundFlight();
            n2 = this.backOff(n2);
        }
    }

    void finish() {
        1 var1_1 = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else {
            this.prepareInboundFlight(null);
            if (this.previousInboundFlight != null) {
                var1_1 = new /* Unavailable Anonymous Inner Class!! */;
            }
        }
        this.recordLayer.handshakeSuccessful(var1_1);
    }

    void resetHandshakeMessagesDigest() {
        this.handshakeHash.reset();
    }

    private int backOff(int n2) {
        return Math.min(n2 * 2, 60000);
    }

    private void checkInboundFlight() {
        Enumeration enumeration = this.currentInboundFlight.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 < this.next_receive_seq) continue;
        }
    }

    private Message getPendingMessage() throws IOException {
        byte[] byArray;
        DTLSReassembler dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf((int)this.next_receive_seq));
        if (dTLSReassembler != null && (byArray = dTLSReassembler.getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, dTLSReassembler.getMsgType(), byArray, null));
        }
        return null;
    }

    private void prepareInboundFlight(Hashtable hashtable) {
        DTLSReliableHandshake.resetAll((Hashtable)this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = hashtable;
    }

    private boolean processRecord(int n2, int n3, byte[] byArray, int n4, int n5) throws IOException {
        int n6;
        int n7;
        boolean bl2 = false;
        while (n5 >= 12 && n5 >= (n7 = (n6 = TlsUtils.readUint24((byte[])byArray, (int)(n4 + 9))) + 12)) {
            int n8;
            int n9 = TlsUtils.readUint24((byte[])byArray, (int)(n4 + 1));
            int n10 = TlsUtils.readUint24((byte[])byArray, (int)(n4 + 6));
            if (n10 + n6 > n9) break;
            short s2 = TlsUtils.readUint8((byte[])byArray, (int)(n4 + 0));
            int n11 = n8 = s2 == 20 ? 1 : 0;
            if (n3 != n8) break;
            int n12 = TlsUtils.readUint16((byte[])byArray, (int)(n4 + 4));
            if (n12 < this.next_receive_seq + n2) {
                DTLSReassembler dTLSReassembler;
                if (n12 >= this.next_receive_seq) {
                    dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf((int)n12));
                    if (dTLSReassembler == null) {
                        dTLSReassembler = new DTLSReassembler(s2, n9);
                        this.currentInboundFlight.put(Integers.valueOf((int)n12), dTLSReassembler);
                    }
                    dTLSReassembler.contributeFragment(s2, n9, byArray, n4 + 12, n10, n6);
                } else if (this.previousInboundFlight != null && (dTLSReassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf((int)n12))) != null) {
                    dTLSReassembler.contributeFragment(s2, n9, byArray, n4 + 12, n10, n6);
                    bl2 = true;
                }
            }
            n4 += n7;
            n5 -= n7;
        }
        int n13 = n6 = bl2 && DTLSReliableHandshake.checkAll((Hashtable)this.previousInboundFlight) ? 1 : 0;
        if (n6 != 0) {
            this.resendOutboundFlight();
            DTLSReliableHandshake.resetAll((Hashtable)this.previousInboundFlight);
        }
        return n6 != 0;
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i2 = 0; i2 < this.outboundFlight.size(); ++i2) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i2));
        }
    }

    private Message updateHandshakeMessagesDigest(Message message) throws IOException {
        if (message.getType() != 0) {
            byte[] byArray = message.getBody();
            byte[] byArray2 = new byte[12];
            TlsUtils.writeUint8((short)message.getType(), (byte[])byArray2, (int)0);
            TlsUtils.writeUint24((int)byArray.length, (byte[])byArray2, (int)1);
            TlsUtils.writeUint16((int)message.getSeq(), (byte[])byArray2, (int)4);
            TlsUtils.writeUint24((int)0, (byte[])byArray2, (int)6);
            TlsUtils.writeUint24((int)byArray.length, (byte[])byArray2, (int)9);
            this.handshakeHash.update(byArray2, 0, byArray2.length);
            this.handshakeHash.update(byArray, 0, byArray.length);
        }
        return message;
    }

    private void writeMessage(Message message) throws IOException {
        int n2;
        int n3 = this.recordLayer.getSendLimit();
        int n4 = n3 - 12;
        if (n4 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n5 = message.getBody().length;
        int n6 = 0;
        do {
            n2 = Math.min(n5 - n6, n4);
            this.writeHandshakeFragment(message, n6, n2);
        } while ((n6 += n2) < n5);
    }

    private void writeHandshakeFragment(Message message, int n2, int n3) throws IOException {
        RecordLayerBuffer recordLayerBuffer = new RecordLayerBuffer(12 + n3);
        TlsUtils.writeUint8((short)message.getType(), (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint24((int)message.getBody().length, (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint16((int)message.getSeq(), (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint24((int)n2, (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint24((int)n3, (OutputStream)recordLayerBuffer);
        recordLayerBuffer.write(message.getBody(), n2, n3);
        recordLayerBuffer.sendToRecordLayer(this.recordLayer);
    }

    private static boolean checkAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((DTLSReassembler)enumeration.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DTLSReassembler)enumeration.nextElement()).reset();
        }
    }

    static /* synthetic */ boolean access$100(DTLSReliableHandshake dTLSReliableHandshake, int n2, int n3, byte[] byArray, int n4, int n5) throws IOException {
        return dTLSReliableHandshake.processRecord(n2, n3, byArray, n4, n5);
    }
}

