/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ByteQueue;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSEpoch;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSHandshakeRetransmit;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DatagramTransport;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsNullCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsPeer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

/*
 * Exception performing whole class analysis ignored.
 */
class DTLSRecordLayer
implements DatagramTransport {
    private static final int RECORD_HEADER_LENGTH = 13;
    private static final int MAX_FRAGMENT_LENGTH = 16384;
    private static final long TCP_MSL = 120000L;
    private static final long RETRANSMIT_TIMEOUT = 240000L;
    private final DatagramTransport transport;
    private final TlsContext context;
    private final TlsPeer peer;
    private final ByteQueue recordQueue = new ByteQueue();
    private volatile boolean closed = false;
    private volatile boolean failed = false;
    private volatile ProtocolVersion readVersion = null;
    private volatile ProtocolVersion writeVersion = null;
    private volatile boolean inHandshake;
    private volatile int plaintextLimit;
    private DTLSEpoch currentEpoch;
    private DTLSEpoch pendingEpoch;
    private DTLSEpoch readEpoch;
    private DTLSEpoch writeEpoch;
    private DTLSHandshakeRetransmit retransmit = null;
    private DTLSEpoch retransmitEpoch = null;
    private long retransmitExpiry = 0L;

    DTLSRecordLayer(DatagramTransport datagramTransport, TlsContext tlsContext, TlsPeer tlsPeer, short s2) {
        this.transport = datagramTransport;
        this.context = tlsContext;
        this.peer = tlsPeer;
        this.inHandshake = true;
        this.currentEpoch = new DTLSEpoch(0, (TlsCipher)new TlsNullCipher(tlsContext));
        this.pendingEpoch = null;
        this.readEpoch = this.currentEpoch;
        this.writeEpoch = this.currentEpoch;
        this.setPlaintextLimit(16384);
    }

    void setPlaintextLimit(int n2) {
        this.plaintextLimit = n2;
    }

    int getReadEpoch() {
        return this.readEpoch.getEpoch();
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion protocolVersion) {
        this.readVersion = protocolVersion;
    }

    void setWriteVersion(ProtocolVersion protocolVersion) {
        this.writeVersion = protocolVersion;
    }

    void initPendingEpoch(TlsCipher tlsCipher) {
        if (this.pendingEpoch != null) {
            throw new IllegalStateException();
        }
        this.pendingEpoch = new DTLSEpoch(this.writeEpoch.getEpoch() + 1, tlsCipher);
    }

    void handshakeSuccessful(DTLSHandshakeRetransmit dTLSHandshakeRetransmit) {
        if (this.readEpoch == this.currentEpoch || this.writeEpoch == this.currentEpoch) {
            throw new IllegalStateException();
        }
        if (dTLSHandshakeRetransmit != null) {
            this.retransmit = dTLSHandshakeRetransmit;
            this.retransmitEpoch = this.currentEpoch;
            this.retransmitExpiry = System.currentTimeMillis() + 240000L;
        }
        this.inHandshake = false;
        this.currentEpoch = this.pendingEpoch;
        this.pendingEpoch = null;
    }

    void resetWriteEpoch() {
        this.writeEpoch = this.retransmitEpoch != null ? this.retransmitEpoch : this.currentEpoch;
    }

    public int getReceiveLimit() throws IOException {
        return Math.min(this.plaintextLimit, this.readEpoch.getCipher().getPlaintextLimit(this.transport.getReceiveLimit() - 13));
    }

    public int getSendLimit() throws IOException {
        return Math.min(this.plaintextLimit, this.writeEpoch.getCipher().getPlaintextLimit(this.transport.getSendLimit() - 13));
    }

    /*
     * Exception decompiling
     */
    public int receive(byte[] var1_1, int var2_2, int var3_3, int var4_4) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void send(byte[] byArray, int n2, int n3) throws IOException {
        short s2 = 23;
        if (this.inHandshake || this.writeEpoch == this.retransmitEpoch) {
            s2 = 22;
            short s3 = TlsUtils.readUint8((byte[])byArray, (int)n2);
            if (s3 == 20) {
                DTLSEpoch dTLSEpoch = null;
                if (this.inHandshake) {
                    dTLSEpoch = this.pendingEpoch;
                } else if (this.writeEpoch == this.retransmitEpoch) {
                    dTLSEpoch = this.currentEpoch;
                }
                if (dTLSEpoch == null) {
                    throw new IllegalStateException();
                }
                byte[] byArray2 = new byte[]{1};
                this.sendRecord((short)20, byArray2, 0, byArray2.length);
                this.writeEpoch = dTLSEpoch;
            }
        }
        this.sendRecord(s2, byArray, n2, n3);
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.inHandshake) {
                this.warn((short)90, "User canceled handshake");
            }
            this.closeTransport();
        }
    }

    void fail(short s2) {
        if (!this.closed) {
            try {
                this.raiseAlert((short)2, s2, null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.failed = true;
            this.closeTransport();
        }
    }

    void failed() {
        if (!this.closed) {
            this.failed = true;
            this.closeTransport();
        }
    }

    void warn(short s2, String string) throws IOException {
        this.raiseAlert((short)1, s2, string, null);
    }

    private void closeTransport() {
        if (!this.closed) {
            try {
                if (!this.failed) {
                    this.warn((short)0, null);
                }
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.closed = true;
        }
    }

    private void raiseAlert(short s2, short s3, String string, Throwable throwable) throws IOException {
        this.peer.notifyAlertRaised(s2, s3, string, throwable);
        byte[] byArray = new byte[]{(byte)s2, (byte)s3};
        this.sendRecord((short)21, byArray, 0, 2);
    }

    private int receiveRecord(byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6;
        if (this.recordQueue.available() > 0) {
            int n7 = 0;
            if (this.recordQueue.available() >= 13) {
                byte[] byArray2 = new byte[2];
                this.recordQueue.read(byArray2, 0, 2, 11);
                n7 = TlsUtils.readUint16((byte[])byArray2, (int)0);
            }
            int n8 = Math.min(this.recordQueue.available(), 13 + n7);
            this.recordQueue.removeData(byArray, n2, n8, 0);
            return n8;
        }
        int n9 = this.transport.receive(byArray, n2, n3, n4);
        if (n9 >= 13 && n9 > (n6 = 13 + (n5 = TlsUtils.readUint16((byte[])byArray, (int)(n2 + 11))))) {
            this.recordQueue.addData(byArray, n2 + n6, n9 - n6);
            n9 = n6;
        }
        return n9;
    }

    private void sendRecord(short s2, byte[] byArray, int n2, int n3) throws IOException {
        if (this.writeVersion == null) {
            return;
        }
        if (n3 > this.plaintextLimit) {
            throw new TlsFatalAlert(80);
        }
        if (n3 < 1 && s2 != 23) {
            throw new TlsFatalAlert(80);
        }
        int n4 = this.writeEpoch.getEpoch();
        long l2 = this.writeEpoch.allocateSequenceNumber();
        byte[] byArray2 = this.writeEpoch.getCipher().encodePlaintext(DTLSRecordLayer.getMacSequenceNumber((int)n4, (long)l2), s2, byArray, n2, n3);
        byte[] byArray3 = new byte[byArray2.length + 13];
        TlsUtils.writeUint8((short)s2, (byte[])byArray3, (int)0);
        TlsUtils.writeVersion((ProtocolVersion)this.writeVersion, (byte[])byArray3, (int)1);
        TlsUtils.writeUint16((int)n4, (byte[])byArray3, (int)3);
        TlsUtils.writeUint48((long)l2, (byte[])byArray3, (int)5);
        TlsUtils.writeUint16((int)byArray2.length, (byte[])byArray3, (int)11);
        System.arraycopy(byArray2, 0, byArray3, 13, byArray2.length);
        this.transport.send(byArray3, 0, byArray3.length);
    }

    private static long getMacSequenceNumber(int n2, long l2) {
        return ((long)n2 & 0xFFFFFFFFL) << 48 | l2;
    }
}

