/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DTLSRecordLayer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.MaxFragmentLength;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsExtensionsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsProtocol;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public abstract class DTLSProtocol {
    protected final SecureRandom secureRandom;

    protected DTLSProtocol(SecureRandom secureRandom) {
        if (secureRandom == null) {
            throw new IllegalArgumentException("'secureRandom' cannot be null");
        }
        this.secureRandom = secureRandom;
    }

    protected void processFinished(byte[] byArray, byte[] byArray2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = TlsUtils.readFully((int)byArray2.length, (InputStream)byteArrayInputStream);
        TlsProtocol.assertEmpty((ByteArrayInputStream)byteArrayInputStream);
        if (!Arrays.constantTimeAreEqual((byte[])byArray2, (byte[])byArray3)) {
            throw new TlsFatalAlert(40);
        }
    }

    protected static void applyMaxFragmentLengthExtension(DTLSRecordLayer dTLSRecordLayer, short s2) throws IOException {
        if (s2 >= 0) {
            if (!MaxFragmentLength.isValid((short)s2)) {
                throw new TlsFatalAlert(80);
            }
            int n2 = 1 << 8 + s2;
            dTLSRecordLayer.setPlaintextLimit(n2);
        }
    }

    protected static short evaluateMaxFragmentLengthExtension(boolean bl2, Hashtable hashtable, Hashtable hashtable2, short s2) throws IOException {
        short s3 = TlsExtensionsUtils.getMaxFragmentLengthExtension((Hashtable)hashtable2);
        if (s3 >= 0 && (!MaxFragmentLength.isValid((short)s3) || !bl2 && s3 != TlsExtensionsUtils.getMaxFragmentLengthExtension((Hashtable)hashtable))) {
            throw new TlsFatalAlert(s2);
        }
        return s3;
    }

    protected static byte[] generateCertificate(Certificate certificate) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificate.encode((OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected static byte[] generateSupplementalData(Vector vector) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsProtocol.writeSupplementalData((OutputStream)byteArrayOutputStream, (Vector)vector);
        return byteArrayOutputStream.toByteArray();
    }

    protected static void validateSelectedCipherSuite(int n2, short s2) throws IOException {
        switch (TlsUtils.getEncryptionAlgorithm((int)n2)) {
            case 1: 
            case 2: {
                throw new TlsFatalAlert(s2);
            }
        }
    }
}

