/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.StreamCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.ChaCha7539Engine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.macs.Poly1305;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Pack;

public class Chacha20Poly1305
implements TlsCipher {
    private static final byte[] ZEROES = new byte[15];
    protected TlsContext context;
    protected ChaCha7539Engine encryptCipher;
    protected ChaCha7539Engine decryptCipher;
    protected byte[] encryptIV;
    protected byte[] decryptIV;

    public Chacha20Poly1305(TlsContext tlsContext) throws IOException {
        KeyParameter keyParameter;
        KeyParameter keyParameter2;
        if (!TlsUtils.isTLSv12((TlsContext)tlsContext)) {
            throw new TlsFatalAlert(80);
        }
        this.context = tlsContext;
        int n2 = 32;
        int n3 = 12;
        int n4 = 2 * n2 + 2 * n3;
        byte[] byArray = TlsUtils.calculateKeyBlock((TlsContext)tlsContext, (int)n4);
        int n5 = 0;
        KeyParameter keyParameter3 = new KeyParameter(byArray, n5, n2);
        KeyParameter keyParameter4 = new KeyParameter(byArray, n5 += n2, n2);
        byte[] byArray2 = Arrays.copyOfRange((byte[])byArray, (int)(n5 += n2), (int)(n5 + n3));
        byte[] byArray3 = Arrays.copyOfRange((byte[])byArray, (int)(n5 += n3), (int)(n5 + n3));
        if ((n5 += n3) != n4) {
            throw new TlsFatalAlert(80);
        }
        this.encryptCipher = new ChaCha7539Engine();
        this.decryptCipher = new ChaCha7539Engine();
        if (tlsContext.isServer()) {
            keyParameter2 = keyParameter4;
            keyParameter = keyParameter3;
            this.encryptIV = byArray3;
            this.decryptIV = byArray2;
        } else {
            keyParameter2 = keyParameter3;
            keyParameter = keyParameter4;
            this.encryptIV = byArray2;
            this.decryptIV = byArray3;
        }
        this.encryptCipher.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter2, this.encryptIV));
        this.decryptCipher.init(false, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, this.decryptIV));
    }

    public int getPlaintextLimit(int n2) {
        return n2 - 16;
    }

    public byte[] encodePlaintext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        KeyParameter keyParameter = this.initRecord((StreamCipher)this.encryptCipher, true, l2, this.encryptIV);
        byte[] byArray2 = new byte[n3 + 16];
        this.encryptCipher.processBytes(byArray, n2, n3, byArray2, 0);
        byte[] byArray3 = this.getAdditionalData(l2, s2, n3);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3, byArray2, 0, n3);
        System.arraycopy(byArray4, 0, byArray2, n3, byArray4.length);
        return byArray2;
    }

    public byte[] decodeCiphertext(long l2, short s2, byte[] byArray, int n2, int n3) throws IOException {
        byte[] byArray2;
        int n4;
        byte[] byArray3;
        if (this.getPlaintextLimit(n3) < 0) {
            throw new TlsFatalAlert(50);
        }
        KeyParameter keyParameter = this.initRecord((StreamCipher)this.decryptCipher, false, l2, this.decryptIV);
        byte[] byArray4 = this.calculateRecordMAC(keyParameter, byArray3 = this.getAdditionalData(l2, s2, n4 = n3 - 16), byArray, n2, n4);
        if (!Arrays.constantTimeAreEqual((byte[])byArray4, (byte[])(byArray2 = Arrays.copyOfRange((byte[])byArray, (int)(n2 + n4), (int)(n2 + n3))))) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray5 = new byte[n4];
        this.decryptCipher.processBytes(byArray, n2, n4, byArray5, 0);
        return byArray5;
    }

    protected KeyParameter initRecord(StreamCipher streamCipher, boolean bl2, long l2, byte[] byArray) {
        byte[] byArray2 = this.calculateNonce(l2, byArray);
        streamCipher.init(bl2, (CipherParameters)new ParametersWithIV(null, byArray2));
        return this.generateRecordMACKey(streamCipher);
    }

    protected byte[] calculateNonce(long l2, byte[] byArray) {
        byte[] byArray2 = new byte[12];
        TlsUtils.writeUint64((long)l2, (byte[])byArray2, (int)4);
        for (int i2 = 0; i2 < 12; ++i2) {
            int n2 = i2;
            byArray2[n2] = (byte)(byArray2[n2] ^ byArray[i2]);
        }
        return byArray2;
    }

    protected KeyParameter generateRecordMACKey(StreamCipher streamCipher) {
        byte[] byArray = new byte[64];
        streamCipher.processBytes(byArray, 0, byArray.length, byArray, 0);
        KeyParameter keyParameter = new KeyParameter(byArray, 0, 32);
        Arrays.fill((byte[])byArray, (byte)0);
        return keyParameter;
    }

    protected byte[] calculateRecordMAC(KeyParameter keyParameter, byte[] byArray, byte[] byArray2, int n2, int n3) {
        Poly1305 poly1305 = new Poly1305();
        poly1305.init((CipherParameters)keyParameter);
        this.updateRecordMACText((Mac)poly1305, byArray, 0, byArray.length);
        this.updateRecordMACText((Mac)poly1305, byArray2, n2, n3);
        this.updateRecordMACLength((Mac)poly1305, byArray.length);
        this.updateRecordMACLength((Mac)poly1305, n3);
        byte[] byArray3 = new byte[poly1305.getMacSize()];
        poly1305.doFinal(byArray3, 0);
        return byArray3;
    }

    protected void updateRecordMACLength(Mac mac, int n2) {
        byte[] byArray = Pack.longToLittleEndian((long)((long)n2 & 0xFFFFFFFFL));
        mac.update(byArray, 0, byArray.length);
    }

    protected void updateRecordMACText(Mac mac, byte[] byArray, int n2, int n3) {
        mac.update(byArray, n2, n3);
        int n4 = n3 % 16;
        if (n4 != 0) {
            mac.update(ZEROES, 0, 16 - n4);
        }
    }

    protected byte[] getAdditionalData(long l2, short s2, int n2) throws IOException {
        byte[] byArray = new byte[13];
        TlsUtils.writeUint64((long)l2, (byte[])byArray, (int)0);
        TlsUtils.writeUint8((short)s2, (byte[])byArray, (int)8);
        TlsUtils.writeVersion((ProtocolVersion)this.context.getServerVersion(), (byte[])byArray, (int)9);
        TlsUtils.writeUint16((int)n2, (byte[])byArray, (int)11);
        return byArray;
    }
}

