/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertChainType;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateURL;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.URLAndHash;

public class CertificateURL {
    protected short type;
    protected Vector urlAndHashList;

    public CertificateURL(short s2, Vector vector) {
        if (!CertChainType.isValid((short)s2)) {
            throw new IllegalArgumentException("'type' is not a valid CertChainType value");
        }
        if (vector == null || vector.isEmpty()) {
            throw new IllegalArgumentException("'urlAndHashList' must have length > 0");
        }
        this.type = s2;
        this.urlAndHashList = vector;
    }

    public short getType() {
        return this.type;
    }

    public Vector getURLAndHashList() {
        return this.urlAndHashList;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint8((short)this.type, (OutputStream)outputStream);
        ListBuffer16 listBuffer16 = new ListBuffer16(this);
        for (int i2 = 0; i2 < this.urlAndHashList.size(); ++i2) {
            URLAndHash uRLAndHash = (URLAndHash)this.urlAndHashList.elementAt(i2);
            uRLAndHash.encode((OutputStream)listBuffer16);
        }
        listBuffer16.encodeTo(outputStream);
    }

    public static CertificateURL parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        short s2 = TlsUtils.readUint8((InputStream)inputStream);
        if (!CertChainType.isValid((short)s2)) {
            throw new TlsFatalAlert(50);
        }
        int n2 = TlsUtils.readUint16((InputStream)inputStream);
        if (n2 < 1) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully((int)n2, (InputStream)inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<URLAndHash> vector = new Vector<URLAndHash>();
        while (byteArrayInputStream.available() > 0) {
            URLAndHash uRLAndHash = URLAndHash.parse((TlsContext)tlsContext, (InputStream)byteArrayInputStream);
            vector.addElement(uRLAndHash);
        }
        return new CertificateURL(s2, vector);
    }
}

