/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x500.X500Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;

public class CertificateRequest {
    protected short[] certificateTypes;
    protected Vector supportedSignatureAlgorithms;
    protected Vector certificateAuthorities;

    public CertificateRequest(short[] sArray, Vector vector, Vector vector2) {
        this.certificateTypes = sArray;
        this.supportedSignatureAlgorithms = vector;
        this.certificateAuthorities = vector2;
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getSupportedSignatureAlgorithms() {
        return this.supportedSignatureAlgorithms;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.certificateTypes == null || this.certificateTypes.length == 0) {
            TlsUtils.writeUint8((int)0, (OutputStream)outputStream);
        } else {
            TlsUtils.writeUint8ArrayWithUint8Length((short[])this.certificateTypes, (OutputStream)outputStream);
        }
        if (this.supportedSignatureAlgorithms != null) {
            TlsUtils.encodeSupportedSignatureAlgorithms((Vector)this.supportedSignatureAlgorithms, (boolean)false, (OutputStream)outputStream);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16((int)0, (OutputStream)outputStream);
        } else {
            Object object;
            int n2;
            Vector<byte[]> vector = new Vector<byte[]>(this.certificateAuthorities.size());
            int n3 = 0;
            for (n2 = 0; n2 < this.certificateAuthorities.size(); ++n2) {
                object = (X500Name)this.certificateAuthorities.elementAt(n2);
                byte[] byArray = object.getEncoded("DER");
                vector.addElement(byArray);
                n3 += byArray.length + 2;
            }
            TlsUtils.checkUint16((int)n3);
            TlsUtils.writeUint16((int)n3, (OutputStream)outputStream);
            for (n2 = 0; n2 < vector.size(); ++n2) {
                object = (byte[])vector.elementAt(n2);
                TlsUtils.writeOpaque16((byte[])object, (OutputStream)outputStream);
            }
        }
    }

    public static CertificateRequest parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        int n2 = TlsUtils.readUint8((InputStream)inputStream);
        short[] sArray = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sArray[i2] = TlsUtils.readUint8((InputStream)inputStream);
        }
        Vector vector = null;
        if (TlsUtils.isTLSv12((TlsContext)tlsContext)) {
            vector = TlsUtils.parseSupportedSignatureAlgorithms((boolean)false, (InputStream)inputStream);
        }
        Vector<X500Name> vector2 = new Vector<X500Name>();
        byte[] byArray = TlsUtils.readOpaque16((InputStream)inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2 = TlsUtils.readOpaque16((InputStream)byteArrayInputStream);
            ASN1Primitive aSN1Primitive = TlsUtils.readDERObject((byte[])byArray2);
            vector2.addElement(X500Name.getInstance((Object)aSN1Primitive));
        }
        return new CertificateRequest(sArray, vector, vector2);
    }
}

