/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.AbstractTlsPeer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.Certificate;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateRequest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.CertificateStatus;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.DefaultTlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.MaxFragmentLength;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.NamedCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.NewSessionTicket;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.ProtocolVersion;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCipherFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsCompression;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsECCUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsExtensionsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsFatalAlert;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsNullCompression;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsServer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsServerContext;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.tls.TlsUtils;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public abstract class AbstractTlsServer
extends AbstractTlsPeer
implements TlsServer {
    protected TlsCipherFactory cipherFactory;
    protected TlsServerContext context;
    protected ProtocolVersion clientVersion;
    protected int[] offeredCipherSuites;
    protected short[] offeredCompressionMethods;
    protected Hashtable clientExtensions;
    protected boolean encryptThenMACOffered;
    protected short maxFragmentLengthOffered;
    protected boolean truncatedHMacOffered;
    protected Vector supportedSignatureAlgorithms;
    protected boolean eccCipherSuitesOffered;
    protected int[] namedCurves;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected ProtocolVersion serverVersion;
    protected int selectedCipherSuite;
    protected short selectedCompressionMethod;
    protected Hashtable serverExtensions;

    public AbstractTlsServer() {
        this((TlsCipherFactory)new DefaultTlsCipherFactory());
    }

    public AbstractTlsServer(TlsCipherFactory tlsCipherFactory) {
        this.cipherFactory = tlsCipherFactory;
    }

    protected boolean allowEncryptThenMAC() {
        return true;
    }

    protected boolean allowTruncatedHMac() {
        return false;
    }

    protected Hashtable checkServerExtensions() {
        this.serverExtensions = TlsExtensionsUtils.ensureExtensionsInitialised((Hashtable)this.serverExtensions);
        return this.serverExtensions;
    }

    protected abstract int[] getCipherSuites();

    protected short[] getCompressionMethods() {
        return new short[]{0};
    }

    protected ProtocolVersion getMaximumVersion() {
        return ProtocolVersion.TLSv11;
    }

    protected ProtocolVersion getMinimumVersion() {
        return ProtocolVersion.TLSv10;
    }

    protected boolean supportsClientECCCapabilities(int[] nArray, short[] sArray) {
        if (nArray == null) {
            return TlsECCUtils.hasAnySupportedNamedCurves();
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (!NamedCurve.isValid((int)n2) || NamedCurve.refersToASpecificNamedCurve((int)n2) && !TlsECCUtils.isSupportedNamedCurve((int)n2)) continue;
            return true;
        }
        return false;
    }

    public void init(TlsServerContext tlsServerContext) {
        this.context = tlsServerContext;
    }

    public void notifyClientVersion(ProtocolVersion protocolVersion) throws IOException {
        this.clientVersion = protocolVersion;
    }

    public void notifyFallback(boolean bl2) throws IOException {
        if (bl2 && this.getMaximumVersion().isLaterVersionOf(this.clientVersion)) {
            throw new TlsFatalAlert(86);
        }
    }

    public void notifyOfferedCipherSuites(int[] nArray) throws IOException {
        this.offeredCipherSuites = nArray;
        this.eccCipherSuitesOffered = TlsECCUtils.containsECCCipherSuites((int[])this.offeredCipherSuites);
    }

    public void notifyOfferedCompressionMethods(short[] sArray) throws IOException {
        this.offeredCompressionMethods = sArray;
    }

    public void processClientExtensions(Hashtable hashtable) throws IOException {
        this.clientExtensions = hashtable;
        if (hashtable != null) {
            this.encryptThenMACOffered = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)hashtable);
            this.maxFragmentLengthOffered = TlsExtensionsUtils.getMaxFragmentLengthExtension((Hashtable)hashtable);
            if (this.maxFragmentLengthOffered >= 0 && !MaxFragmentLength.isValid((short)this.maxFragmentLengthOffered)) {
                throw new TlsFatalAlert(47);
            }
            this.truncatedHMacOffered = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)hashtable);
            this.supportedSignatureAlgorithms = TlsUtils.getSignatureAlgorithmsExtension((Hashtable)hashtable);
            if (this.supportedSignatureAlgorithms != null && !TlsUtils.isSignatureAlgorithmsExtensionAllowed((ProtocolVersion)this.clientVersion)) {
                throw new TlsFatalAlert(47);
            }
            this.namedCurves = TlsECCUtils.getSupportedEllipticCurvesExtension((Hashtable)hashtable);
            this.clientECPointFormats = TlsECCUtils.getSupportedPointFormatsExtension((Hashtable)hashtable);
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        if (this.getMinimumVersion().isEqualOrEarlierVersionOf(this.clientVersion)) {
            ProtocolVersion protocolVersion = this.getMaximumVersion();
            if (this.clientVersion.isEqualOrEarlierVersionOf(protocolVersion)) {
                this.serverVersion = this.clientVersion;
                return this.serverVersion;
            }
            if (this.clientVersion.isLaterVersionOf(protocolVersion)) {
                this.serverVersion = protocolVersion;
                return this.serverVersion;
            }
        }
        throw new TlsFatalAlert(70);
    }

    public int getSelectedCipherSuite() throws IOException {
        Vector vector = TlsUtils.getUsableSignatureAlgorithms((Vector)this.supportedSignatureAlgorithms);
        boolean bl2 = this.supportsClientECCCapabilities(this.namedCurves, this.clientECPointFormats);
        int[] nArray = this.getCipherSuites();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (!Arrays.contains((int[])this.offeredCipherSuites, (int)n2) || !bl2 && TlsECCUtils.isECCCipherSuite((int)n2) || !TlsUtils.isValidCipherSuiteForVersion((int)n2, (ProtocolVersion)this.serverVersion) || !TlsUtils.isValidCipherSuiteForSignatureAlgorithms((int)n2, (Vector)vector)) continue;
            this.selectedCipherSuite = n2;
            return this.selectedCipherSuite;
        }
        throw new TlsFatalAlert(40);
    }

    public short getSelectedCompressionMethod() throws IOException {
        short[] sArray = this.getCompressionMethods();
        for (int i2 = 0; i2 < sArray.length; ++i2) {
            if (!Arrays.contains((short[])this.offeredCompressionMethods, (short)sArray[i2])) continue;
            this.selectedCompressionMethod = sArray[i2];
            return this.selectedCompressionMethod;
        }
        throw new TlsFatalAlert(40);
    }

    public Hashtable getServerExtensions() throws IOException {
        if (this.encryptThenMACOffered && this.allowEncryptThenMAC() && TlsUtils.isBlockCipherSuite((int)this.selectedCipherSuite)) {
            TlsExtensionsUtils.addEncryptThenMACExtension((Hashtable)this.checkServerExtensions());
        }
        if (this.maxFragmentLengthOffered >= 0 && MaxFragmentLength.isValid((short)this.maxFragmentLengthOffered)) {
            TlsExtensionsUtils.addMaxFragmentLengthExtension((Hashtable)this.checkServerExtensions(), (short)this.maxFragmentLengthOffered);
        }
        if (this.truncatedHMacOffered && this.allowTruncatedHMac()) {
            TlsExtensionsUtils.addTruncatedHMacExtension((Hashtable)this.checkServerExtensions());
        }
        if (this.clientECPointFormats != null && TlsECCUtils.isECCCipherSuite((int)this.selectedCipherSuite)) {
            this.serverECPointFormats = new short[]{0, 1, 2};
            TlsECCUtils.addSupportedPointFormatsExtension((Hashtable)this.checkServerExtensions(), (short[])this.serverECPointFormats);
        }
        return this.serverExtensions;
    }

    public Vector getServerSupplementalData() throws IOException {
        return null;
    }

    public CertificateStatus getCertificateStatus() throws IOException {
        return null;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        return null;
    }

    public void processClientSupplementalData(Vector vector) throws IOException {
        if (vector != null) {
            throw new TlsFatalAlert(10);
        }
    }

    public void notifyClientCertificate(Certificate certificate) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public TlsCompression getCompression() throws IOException {
        switch (this.selectedCompressionMethod) {
            case 0: {
                return new TlsNullCompression();
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsCipher getCipher() throws IOException {
        int n2 = TlsUtils.getEncryptionAlgorithm((int)this.selectedCipherSuite);
        int n3 = TlsUtils.getMACAlgorithm((int)this.selectedCipherSuite);
        return this.cipherFactory.createCipher((TlsContext)this.context, n2, n3);
    }

    public NewSessionTicket getNewSessionTicket() throws IOException {
        return new NewSessionTicket(0L, TlsUtils.EMPTY_BYTES);
    }
}

