/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;

public class ISOTrailers {
    private static final Map<String, Integer> trailerMap;
    public static final int TRAILER_IMPLICIT = 188;
    public static final int TRAILER_RIPEMD160 = 12748;
    public static final int TRAILER_RIPEMD128 = 13004;
    public static final int TRAILER_SHA1 = 13260;
    public static final int TRAILER_SHA256 = 13516;
    public static final int TRAILER_SHA512 = 13772;
    public static final int TRAILER_SHA384 = 14028;
    public static final int TRAILER_WHIRLPOOL = 14284;
    public static final int TRAILER_SHA224 = 14540;
    public static final int TRAILER_SHA512_224 = 14796;
    public static final int TRAILER_SHA512_256 = 15052;

    public static Integer getTrailer(Digest digest) {
        return (Integer)trailerMap.get(digest.getAlgorithmName());
    }

    public static boolean noTrailerAvailable(Digest digest) {
        return !trailerMap.containsKey(digest.getAlgorithmName());
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("RIPEMD128", Integers.valueOf((int)13004));
        hashMap.put("RIPEMD160", Integers.valueOf((int)12748));
        hashMap.put("SHA-1", Integers.valueOf((int)13260));
        hashMap.put("SHA-224", Integers.valueOf((int)14540));
        hashMap.put("SHA-256", Integers.valueOf((int)13516));
        hashMap.put("SHA-384", Integers.valueOf((int)14028));
        hashMap.put("SHA-512", Integers.valueOf((int)13772));
        hashMap.put("SHA-512/224", Integers.valueOf((int)14796));
        hashMap.put("SHA-512/256", Integers.valueOf((int)15052));
        hashMap.put("Whirlpool", Integers.valueOf((int)14284));
        trailerMap = Collections.unmodifiableMap(hashMap);
    }
}

