/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricBlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DataLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Signer;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class GenericSigner
implements Signer {
    private final AsymmetricBlockCipher engine;
    private final Digest digest;
    private boolean forSigning;

    public GenericSigner(AsymmetricBlockCipher asymmetricBlockCipher, Digest digest) {
        this.engine = asymmetricBlockCipher;
        this.digest = digest;
    }

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        AsymmetricKeyParameter asymmetricKeyParameter = cipherParameters instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)cipherParameters).getParameters() : (AsymmetricKeyParameter)cipherParameters;
        if (bl2 && !asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("signing requires private key");
        }
        if (!bl2 && asymmetricKeyParameter.isPrivate()) {
            throw new IllegalArgumentException("verification requires public key");
        }
        this.reset();
        this.engine.init(bl2, cipherParameters);
    }

    public void update(byte by2) {
        this.digest.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.digest.update(byArray, n2, n3);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        if (!this.forSigning) {
            throw new IllegalStateException("GenericSigner not initialised for signature generation.");
        }
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return this.engine.processBlock(byArray, 0, byArray.length);
    }

    public boolean verifySignature(byte[] byArray) {
        if (this.forSigning) {
            throw new IllegalStateException("GenericSigner not initialised for verification");
        }
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        try {
            byte[] byArray3 = this.engine.processBlock(byArray, 0, byArray.length);
            if (byArray3.length < byArray2.length) {
                byte[] byArray4 = new byte[byArray2.length];
                System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
                byArray3 = byArray4;
            }
            return Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])byArray2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void reset() {
        this.digest.reset();
    }
}

