/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DSA;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DataLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators.ECKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECConstants;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;

public class ECNRSigner
implements DSA {
    private boolean forSigning;
    private ECKeyParameters key;
    private SecureRandom random;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        this.forSigning = bl2;
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (ECPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (ECPrivateKeyParameters)cipherParameters;
            }
        } else {
            this.key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        Object object;
        AsymmetricCipherKeyPair asymmetricCipherKeyPair;
        Object object2;
        BigInteger[] bigIntegerArray;
        if (!this.forSigning) {
            throw new IllegalStateException("not initialised for signing");
        }
        BigInteger bigInteger = ((ECPrivateKeyParameters)this.key).getParameters().getN();
        int n2 = bigInteger.bitLength();
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        int n3 = bigInteger2.bitLength();
        ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)this.key;
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        do {
            object = new ECKeyPairGenerator();
            object.init((KeyGenerationParameters)new ECKeyGenerationParameters(eCPrivateKeyParameters.getParameters(), this.random));
        } while ((bigInteger3 = (bigIntegerArray = (object2 = (ECPublicKeyParameters)(asymmetricCipherKeyPair = object.generateKeyPair()).getPublic()).getQ().getAffineXCoord().toBigInteger()).add(bigInteger2).mod(bigInteger)).equals(ECConstants.ZERO));
        object = eCPrivateKeyParameters.getD();
        object2 = ((ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate()).getD();
        bigInteger4 = ((BigInteger)object2).subtract(bigInteger3.multiply((BigInteger)object)).mod(bigInteger);
        bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (this.forSigning) {
            throw new IllegalStateException("not initialised for verifying");
        }
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)this.key;
        BigInteger bigInteger3 = eCPublicKeyParameters.getParameters().getN();
        int n2 = bigInteger3.bitLength();
        BigInteger bigInteger4 = new BigInteger(1, byArray);
        int n3 = bigInteger4.bitLength();
        if (n3 > n2) {
            throw new DataLengthException("input too large for ECNR key.");
        }
        if (bigInteger.compareTo(ECConstants.ONE) < 0 || bigInteger.compareTo(bigInteger3) >= 0) {
            return false;
        }
        if (bigInteger2.compareTo(ECConstants.ZERO) < 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        ECPoint eCPoint2 = eCPublicKeyParameters.getParameters().getG();
        ECPoint eCPoint3 = ECAlgorithms.sumOfTwoMultiplies((ECPoint)eCPoint2, (BigInteger)bigInteger2, (ECPoint)(eCPoint = eCPublicKeyParameters.getQ()), (BigInteger)bigInteger).normalize();
        if (eCPoint3.isInfinity()) {
            return false;
        }
        BigInteger bigInteger5 = eCPoint3.getAffineXCoord().toBigInteger();
        BigInteger bigInteger6 = bigInteger.subtract(bigInteger5).mod(bigInteger3);
        return bigInteger6.equals(bigInteger4);
    }
}

