/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DSA;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECMultiplier;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.FixedPointCombMultiplier;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

/*
 * Exception performing whole class analysis ignored.
 */
public class DSTU4145Signer
implements DSA {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private ECKeyParameters key;
    private SecureRandom random;

    public void init(boolean bl2, CipherParameters cipherParameters) {
        if (bl2) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                cipherParameters = parametersWithRandom.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
            }
            this.key = (ECPrivateKeyParameters)cipherParameters;
        } else {
            this.key = (ECPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        BigInteger bigInteger;
        ECFieldElement eCFieldElement;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        ECFieldElement eCFieldElement2;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement3 = DSTU4145Signer.hash2FieldElement((ECCurve)eCCurve, (byte[])byArray);
        if (eCFieldElement3.isZero()) {
            eCFieldElement3 = eCCurve.fromBigInteger(ONE);
        }
        BigInteger bigInteger4 = eCDomainParameters.getN();
        BigInteger bigInteger5 = ((ECPrivateKeyParameters)this.key).getD();
        ECMultiplier eCMultiplier = this.createBasePointMultiplier();
        do {
            bigInteger3 = DSTU4145Signer.generateRandomInteger((BigInteger)bigInteger4, (SecureRandom)this.random);
        } while ((eCFieldElement2 = eCMultiplier.multiply(eCDomainParameters.getG(), bigInteger3).normalize().getAffineXCoord()).isZero() || (bigInteger2 = DSTU4145Signer.fieldElement2Integer((BigInteger)bigInteger4, (ECFieldElement)(eCFieldElement = eCFieldElement3.multiply(eCFieldElement2)))).signum() == 0 || (bigInteger = bigInteger2.multiply(bigInteger5).add(bigInteger3).mod(bigInteger4)).signum() == 0);
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        ECPoint eCPoint;
        if (bigInteger.signum() <= 0 || bigInteger2.signum() <= 0) {
            return false;
        }
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        BigInteger bigInteger3 = eCDomainParameters.getN();
        if (bigInteger.compareTo(bigInteger3) >= 0 || bigInteger2.compareTo(bigInteger3) >= 0) {
            return false;
        }
        ECCurve eCCurve = eCDomainParameters.getCurve();
        ECFieldElement eCFieldElement = DSTU4145Signer.hash2FieldElement((ECCurve)eCCurve, (byte[])byArray);
        if (eCFieldElement.isZero()) {
            eCFieldElement = eCCurve.fromBigInteger(ONE);
        }
        if ((eCPoint = ECAlgorithms.sumOfTwoMultiplies((ECPoint)eCDomainParameters.getG(), (BigInteger)bigInteger2, (ECPoint)((ECPublicKeyParameters)this.key).getQ(), (BigInteger)bigInteger).normalize()).isInfinity()) {
            return false;
        }
        ECFieldElement eCFieldElement2 = eCFieldElement.multiply(eCPoint.getAffineXCoord());
        return DSTU4145Signer.fieldElement2Integer((BigInteger)bigInteger3, (ECFieldElement)eCFieldElement2).compareTo(bigInteger) == 0;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private static BigInteger generateRandomInteger(BigInteger bigInteger, SecureRandom secureRandom) {
        return new BigInteger(bigInteger.bitLength() - 1, secureRandom);
    }

    private static ECFieldElement hash2FieldElement(ECCurve eCCurve, byte[] byArray) {
        byte[] byArray2 = Arrays.reverse((byte[])byArray);
        return eCCurve.fromBigInteger(DSTU4145Signer.truncate((BigInteger)new BigInteger(1, byArray2), (int)eCCurve.getFieldSize()));
    }

    private static BigInteger fieldElement2Integer(BigInteger bigInteger, ECFieldElement eCFieldElement) {
        return DSTU4145Signer.truncate((BigInteger)eCFieldElement.toBigInteger(), (int)(bigInteger.bitLength() - 1));
    }

    private static BigInteger truncate(BigInteger bigInteger, int n2) {
        if (bigInteger.bitLength() > n2) {
            bigInteger = bigInteger.mod(ONE.shiftLeft(n2));
        }
        return bigInteger;
    }
}

