/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng;

import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BlockCipher;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.BasicEntropySourceProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.DRBGProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.EntropySourceProvider;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.SP800SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.prng.SP800SecureRandomBuilder;

public class SP800SecureRandomBuilder {
    private final SecureRandom random;
    private final EntropySourceProvider entropySourceProvider;
    private byte[] personalizationString;
    private int securityStrength = 256;
    private int entropyBitsRequired = 256;

    public SP800SecureRandomBuilder() {
        this(CryptoServicesRegistrar.getSecureRandom(), false);
    }

    public SP800SecureRandomBuilder(SecureRandom secureRandom, boolean bl2) {
        this.random = secureRandom;
        this.entropySourceProvider = new BasicEntropySourceProvider(this.random, bl2);
    }

    public SP800SecureRandomBuilder(EntropySourceProvider entropySourceProvider) {
        this.random = null;
        this.entropySourceProvider = entropySourceProvider;
    }

    public SP800SecureRandomBuilder setPersonalizationString(byte[] byArray) {
        this.personalizationString = byArray;
        return this;
    }

    public SP800SecureRandomBuilder setSecurityStrength(int n2) {
        this.securityStrength = n2;
        return this;
    }

    public SP800SecureRandomBuilder setEntropyBitsRequired(int n2) {
        this.entropyBitsRequired = n2;
        return this;
    }

    public SP800SecureRandom buildHash(Digest digest, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), (DRBGProvider)new HashDRBGProvider(digest, byArray, this.personalizationString, this.securityStrength), bl2);
    }

    public SP800SecureRandom buildCTR(BlockCipher blockCipher, int n2, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), (DRBGProvider)new CTRDRBGProvider(blockCipher, n2, byArray, this.personalizationString, this.securityStrength), bl2);
    }

    public SP800SecureRandom buildHMAC(Mac mac, byte[] byArray, boolean bl2) {
        return new SP800SecureRandom(this.random, this.entropySourceProvider.get(this.entropyBitsRequired), (DRBGProvider)new HMacDRBGProvider(mac, byArray, this.personalizationString, this.securityStrength), bl2);
    }
}

