/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.gcm;

import java.util.Vector;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.gcm.GCMExponentiator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.modes.gcm.GCMUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    public void init(byte[] byArray) {
        long[] lArray = GCMUtil.asLongs((byte[])byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual((long[])lArray, (long[])((long[])this.lookupPowX2.elementAt(0)))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(lArray);
    }

    public void exponentiateX(long l2, byte[] byArray) {
        long[] lArray = GCMUtil.oneAsLongs();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                this.ensureAvailable(n2);
                GCMUtil.multiply((long[])lArray, (long[])((long[])this.lookupPowX2.elementAt(n2)));
            }
            ++n2;
            l2 >>>= 1;
        }
        GCMUtil.asBytes((long[])lArray, (byte[])byArray);
    }

    private void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size();
        if (n3 <= n2) {
            long[] lArray = (long[])this.lookupPowX2.elementAt(n3 - 1);
            do {
                lArray = Arrays.clone((long[])lArray);
                GCMUtil.square((long[])lArray, (long[])lArray);
                this.lookupPowX2.addElement(lArray);
            } while (++n3 <= n2);
        }
    }
}

