/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.kems;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DerivationFunction;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DerivationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyEncapsulation;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KDFParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.BigIntegers;

public class RSAKeyEncapsulation
implements KeyEncapsulation {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private DerivationFunction kdf;
    private SecureRandom rnd;
    private RSAKeyParameters key;

    public RSAKeyEncapsulation(DerivationFunction derivationFunction, SecureRandom secureRandom) {
        this.kdf = derivationFunction;
        this.rnd = secureRandom;
    }

    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        if (!(cipherParameters instanceof RSAKeyParameters)) {
            throw new IllegalArgumentException("RSA key required");
        }
        this.key = (RSAKeyParameters)cipherParameters;
    }

    public CipherParameters encrypt(byte[] byArray, int n2, int n3) throws IllegalArgumentException {
        if (this.key.isPrivate()) {
            throw new IllegalArgumentException("Public key required for encryption");
        }
        BigInteger bigInteger = this.key.getModulus();
        BigInteger bigInteger2 = this.key.getExponent();
        BigInteger bigInteger3 = BigIntegers.createRandomInRange((BigInteger)ZERO, (BigInteger)bigInteger.subtract(ONE), (SecureRandom)this.rnd);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        byte[] byArray2 = BigIntegers.asUnsignedByteArray((int)((bigInteger.bitLength() + 7) / 8), (BigInteger)bigInteger4);
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        return this.generateKey(bigInteger, bigInteger3, n3);
    }

    public CipherParameters encrypt(byte[] byArray, int n2) {
        return this.encrypt(byArray, 0, n2);
    }

    public CipherParameters decrypt(byte[] byArray, int n2, int n3, int n4) throws IllegalArgumentException {
        if (!this.key.isPrivate()) {
            throw new IllegalArgumentException("Private key required for decryption");
        }
        BigInteger bigInteger = this.key.getModulus();
        BigInteger bigInteger2 = this.key.getExponent();
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        BigInteger bigInteger3 = new BigInteger(1, byArray2);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return this.generateKey(bigInteger, bigInteger4, n4);
    }

    public CipherParameters decrypt(byte[] byArray, int n2) {
        return this.decrypt(byArray, 0, byArray.length, n2);
    }

    protected KeyParameter generateKey(BigInteger bigInteger, BigInteger bigInteger2, int n2) {
        byte[] byArray = BigIntegers.asUnsignedByteArray((int)((bigInteger.bitLength() + 7) / 8), (BigInteger)bigInteger2);
        this.kdf.init((DerivationParameters)new KDFParameters(byArray, null));
        byte[] byArray2 = new byte[n2];
        this.kdf.generateBytes(byArray2, 0, byArray2.length);
        return new KeyParameter(byArray2);
    }
}

