/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPair;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.AsymmetricCipherKeyPairGenerator;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.KeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.AsymmetricKeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.RSAPrivateCrtKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.Primes;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.WNafUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (RSAKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = null;
        boolean bl2 = false;
        int n2 = this.param.getStrength();
        int n3 = (n2 + 1) / 2;
        int n4 = n2 - n3;
        int n5 = n2 / 2 - 100;
        if (n5 < n2 / 3) {
            n5 = n2 / 3;
        }
        int n6 = n2 >> 2;
        BigInteger bigInteger = BigInteger.valueOf(2L).pow(n2 / 2);
        BigInteger bigInteger2 = ONE.shiftLeft(n2 - 1);
        BigInteger bigInteger3 = ONE.shiftLeft(n5);
        while (!bl2) {
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            BigInteger bigInteger7;
            BigInteger bigInteger8;
            BigInteger bigInteger9;
            BigInteger bigInteger10;
            BigInteger bigInteger11;
            BigInteger bigInteger12 = this.param.getPublicExponent();
            BigInteger bigInteger13 = this.chooseRandomPrime(n3, bigInteger12, bigInteger2);
            while (true) {
                if ((bigInteger11 = (bigInteger10 = this.chooseRandomPrime(n4, bigInteger12, bigInteger2)).subtract(bigInteger13).abs()).bitLength() < n5 || bigInteger11.compareTo(bigInteger3) <= 0) {
                    continue;
                }
                bigInteger9 = bigInteger13.multiply(bigInteger10);
                if (bigInteger9.bitLength() != n2) {
                    bigInteger13 = bigInteger13.max(bigInteger10);
                    continue;
                }
                if (WNafUtil.getNafWeight((BigInteger)bigInteger9) >= n6) break;
                bigInteger13 = this.chooseRandomPrime(n3, bigInteger12, bigInteger2);
            }
            if (bigInteger13.compareTo(bigInteger10) < 0) {
                bigInteger8 = bigInteger13;
                bigInteger13 = bigInteger10;
                bigInteger10 = bigInteger8;
            }
            if ((bigInteger7 = bigInteger12.modInverse(bigInteger6 = (bigInteger5 = bigInteger13.subtract(ONE)).divide(bigInteger8 = bigInteger5.gcd(bigInteger4 = bigInteger10.subtract(ONE))).multiply(bigInteger4))).compareTo(bigInteger) <= 0) continue;
            bl2 = true;
            bigInteger11 = bigInteger7.remainder(bigInteger5);
            BigInteger bigInteger14 = bigInteger7.remainder(bigInteger4);
            BigInteger bigInteger15 = bigInteger10.modInverse(bigInteger13);
            asymmetricCipherKeyPair = new AsymmetricCipherKeyPair((AsymmetricKeyParameter)new RSAKeyParameters(false, bigInteger9, bigInteger12), (AsymmetricKeyParameter)new RSAPrivateCrtKeyParameters(bigInteger9, bigInteger12, bigInteger7, bigInteger13, bigInteger10, bigInteger11, bigInteger14, bigInteger15));
        }
        return asymmetricCipherKeyPair;
    }

    protected BigInteger chooseRandomPrime(int n2, BigInteger bigInteger, BigInteger bigInteger2) {
        for (int i2 = 0; i2 != 5 * n2; ++i2) {
            BigInteger bigInteger3 = new BigInteger(n2, 1, this.param.getRandom());
            if (bigInteger3.mod(bigInteger).equals(ONE) || bigInteger3.multiply(bigInteger3).compareTo(bigInteger2) < 0 || !this.isProbablePrime(bigInteger3) || !bigInteger.gcd(bigInteger3.subtract(ONE)).equals(ONE)) continue;
            return bigInteger3;
        }
        throw new IllegalStateException("unable to generate prime number for RSA key");
    }

    protected boolean isProbablePrime(BigInteger bigInteger) {
        int n2 = RSAKeyPairGenerator.getNumberOfIterations((int)bigInteger.bitLength(), (int)this.param.getCertainty());
        return !Primes.hasAnySmallFactors((BigInteger)bigInteger) && Primes.isMRProbablePrime((BigInteger)bigInteger, (SecureRandom)this.param.getRandom(), (int)n2);
    }

    private static int getNumberOfIterations(int n2, int n3) {
        if (n2 >= 1536) {
            return n3 <= 100 ? 3 : (n3 <= 128 ? 4 : 4 + (n3 - 128 + 1) / 2);
        }
        if (n2 >= 1024) {
            return n3 <= 100 ? 4 : (n3 <= 112 ? 5 : 5 + (n3 - 112 + 1) / 2);
        }
        if (n2 >= 512) {
            return n3 <= 80 ? 5 : (n3 <= 100 ? 7 : 7 + (n3 - 100 + 1) / 2);
        }
        return n3 <= 80 ? 40 : 40 + (n3 - 80 + 1) / 2;
    }
}

