/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA1Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAParameterGenerationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DSAValidationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.util.DigestFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.BigIntegers;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.encoders.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class DSAParametersGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private Digest digest;
    private int L;
    private int N;
    private int certainty;
    private int iterations;
    private SecureRandom random;
    private boolean use186_3;
    private int usageIndex;

    public DSAParametersGenerator() {
        this(DigestFactory.createSHA1());
    }

    public DSAParametersGenerator(Digest digest) {
        this.digest = digest;
    }

    public void init(int n2, int n3, SecureRandom secureRandom) {
        this.L = n2;
        this.N = DSAParametersGenerator.getDefaultN((int)n2);
        this.certainty = n3;
        this.iterations = Math.max(DSAParametersGenerator.getMinimumIterations((int)this.L), (n3 + 1) / 2);
        this.random = secureRandom;
        this.use186_3 = false;
        this.usageIndex = -1;
    }

    public void init(DSAParameterGenerationParameters dSAParameterGenerationParameters) {
        int n2 = dSAParameterGenerationParameters.getL();
        int n3 = dSAParameterGenerationParameters.getN();
        if (n2 < 1024 || n2 > 3072 || n2 % 1024 != 0) {
            throw new IllegalArgumentException("L values must be between 1024 and 3072 and a multiple of 1024");
        }
        if (n2 == 1024 && n3 != 160) {
            throw new IllegalArgumentException("N must be 160 for L = 1024");
        }
        if (n2 == 2048 && n3 != 224 && n3 != 256) {
            throw new IllegalArgumentException("N must be 224 or 256 for L = 2048");
        }
        if (n2 == 3072 && n3 != 256) {
            throw new IllegalArgumentException("N must be 256 for L = 3072");
        }
        if (this.digest.getDigestSize() * 8 < n3) {
            throw new IllegalStateException("Digest output size too small for value of N");
        }
        this.L = n2;
        this.N = n3;
        this.certainty = dSAParameterGenerationParameters.getCertainty();
        this.iterations = Math.max(DSAParametersGenerator.getMinimumIterations((int)n2), (this.certainty + 1) / 2);
        this.random = dSAParameterGenerationParameters.getRandom();
        this.use186_3 = true;
        this.usageIndex = dSAParameterGenerationParameters.getUsageIndex();
    }

    public DSAParameters generateParameters() {
        return this.use186_3 ? this.generateParameters_FIPS186_3() : this.generateParameters_FIPS186_2();
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_2() {
        var1_1 = new byte[20];
        var2_2 = new byte[20];
        var3_3 = new byte[20];
        var4_4 = new byte[20];
        var5_5 = (this.L - 1) / 160;
        var6_6 = new byte[this.L / 8];
        if (!(this.digest instanceof SHA1Digest)) {
            throw new IllegalStateException("can only use SHA-1 for generating FIPS 186-2 parameters");
        }
        block0: while (true) {
            this.random.nextBytes(var1_1);
            DSAParametersGenerator.hash((Digest)this.digest, (byte[])var1_1, (byte[])var2_2, (int)0);
            System.arraycopy(var1_1, 0, var3_3, 0, var1_1.length);
            DSAParametersGenerator.inc((byte[])var3_3);
            DSAParametersGenerator.hash((Digest)this.digest, (byte[])var3_3, (byte[])var3_3, (int)0);
            for (var7_8 = 0; var7_8 != var4_4.length; ++var7_8) {
                var4_4[var7_8] = (byte)(var2_2[var7_8] ^ var3_3[var7_8]);
            }
            var4_4[0] = (byte)(var4_4[0] | -128);
            var4_4[19] = (byte)(var4_4[19] | 1);
            var7_7 = new BigInteger(1, var4_4);
            if (!this.isProbablePrime(var7_7)) continue;
            var8_9 = Arrays.clone((byte[])var1_1);
            DSAParametersGenerator.inc((byte[])var8_9);
            var9_10 = 0;
            while (true) {
                if (var9_10 < 4096) ** break;
                continue block0;
                for (var10_12 = 1; var10_12 <= var5_5; ++var10_12) {
                    DSAParametersGenerator.inc((byte[])var8_9);
                    DSAParametersGenerator.hash((Digest)this.digest, (byte[])var8_9, (byte[])var6_6, (int)(var6_6.length - var10_12 * var2_2.length));
                }
                var10_12 = var6_6.length - var5_5 * var2_2.length;
                DSAParametersGenerator.inc((byte[])var8_9);
                DSAParametersGenerator.hash((Digest)this.digest, (byte[])var8_9, (byte[])var2_2, (int)0);
                System.arraycopy(var2_2, var2_2.length - var10_12, var6_6, 0, var10_12);
                var6_6[0] = (byte)(var6_6[0] | -128);
                var10_11 = new BigInteger(1, var6_6);
                var11_13 = var10_11.mod(var7_7.shiftLeft(1));
                var12_14 = var10_11.subtract(var11_13.subtract(DSAParametersGenerator.ONE));
                if (var12_14.bitLength() == this.L && this.isProbablePrime(var12_14)) {
                    var13_15 = DSAParametersGenerator.calculateGenerator_FIPS186_2((BigInteger)var12_14, (BigInteger)var7_7, (SecureRandom)this.random);
                    return new DSAParameters(var12_14, var7_7, var13_15, new DSAValidationParameters(var1_1, var9_10));
                }
                ++var9_10;
            }
            break;
        }
    }

    private static BigInteger calculateGenerator_FIPS186_2(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5 = bigInteger.subtract(ONE).divide(bigInteger2);
        BigInteger bigInteger6 = bigInteger.subtract(TWO);
        while ((bigInteger4 = (bigInteger3 = BigIntegers.createRandomInRange((BigInteger)TWO, (BigInteger)bigInteger6, (SecureRandom)secureRandom)).modPow(bigInteger5, bigInteger)).bitLength() <= 1) {
        }
        return bigInteger4;
    }

    /*
     * Unable to fully structure code
     */
    private DSAParameters generateParameters_FIPS186_3() {
        var1_1 = this.digest;
        var2_2 = var1_1.getDigestSize() * 8;
        var3_3 = this.N;
        var4_4 = new byte[var3_3 / 8];
        var5_5 = (this.L - 1) / var2_2;
        var6_6 = (this.L - 1) % var2_2;
        var7_7 = new byte[this.L / 8];
        var8_8 = new byte[var1_1.getDigestSize()];
        block0: while (true) {
            this.random.nextBytes(var4_4);
            DSAParametersGenerator.hash((Digest)var1_1, (byte[])var4_4, (byte[])var8_8, (int)0);
            var9_9 = new BigInteger(1, var8_8).mod(DSAParametersGenerator.ONE.shiftLeft(this.N - 1));
            var10_10 = var9_9.setBit(0).setBit(this.N - 1);
            if (!this.isProbablePrime(var10_10)) continue;
            var11_11 = Arrays.clone((byte[])var4_4);
            var12_12 = 4 * this.L;
            var13_13 = 0;
            while (true) {
                if (var13_13 < var12_12) ** break;
                continue block0;
                for (var14_15 = 1; var14_15 <= var5_5; ++var14_15) {
                    DSAParametersGenerator.inc((byte[])var11_11);
                    DSAParametersGenerator.hash((Digest)var1_1, (byte[])var11_11, (byte[])var7_7, (int)(var7_7.length - var14_15 * var8_8.length));
                }
                var14_15 = var7_7.length - var5_5 * var8_8.length;
                DSAParametersGenerator.inc((byte[])var11_11);
                DSAParametersGenerator.hash((Digest)var1_1, (byte[])var11_11, (byte[])var8_8, (int)0);
                System.arraycopy(var8_8, var8_8.length - var14_15, var7_7, 0, var14_15);
                var7_7[0] = (byte)(var7_7[0] | -128);
                var14_14 = new BigInteger(1, var7_7);
                var15_16 = var14_14.mod(var10_10.shiftLeft(1));
                var16_17 = var14_14.subtract(var15_16.subtract(DSAParametersGenerator.ONE));
                if (var16_17.bitLength() == this.L && this.isProbablePrime(var16_17)) {
                    if (this.usageIndex >= 0 && (var17_18 = DSAParametersGenerator.calculateGenerator_FIPS186_3_Verifiable((Digest)var1_1, (BigInteger)var16_17, (BigInteger)var10_10, (byte[])var4_4, (int)this.usageIndex)) != null) {
                        return new DSAParameters(var16_17, var10_10, var17_18, new DSAValidationParameters(var4_4, var13_13, this.usageIndex));
                    }
                    var17_18 = DSAParametersGenerator.calculateGenerator_FIPS186_3_Unverifiable((BigInteger)var16_17, (BigInteger)var10_10, (SecureRandom)this.random);
                    return new DSAParameters(var16_17, var10_10, var17_18, new DSAValidationParameters(var4_4, var13_13));
                }
                ++var13_13;
            }
            break;
        }
    }

    private boolean isProbablePrime(BigInteger bigInteger) {
        return bigInteger.isProbablePrime(this.certainty);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Unverifiable(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        return DSAParametersGenerator.calculateGenerator_FIPS186_2((BigInteger)bigInteger, (BigInteger)bigInteger2, (SecureRandom)secureRandom);
    }

    private static BigInteger calculateGenerator_FIPS186_3_Verifiable(Digest digest, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, int n2) {
        BigInteger bigInteger3 = bigInteger.subtract(ONE).divide(bigInteger2);
        byte[] byArray2 = Hex.decode((String)"6767656E");
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1 + 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        byArray3[byArray3.length - 3] = (byte)n2;
        byte[] byArray4 = new byte[digest.getDigestSize()];
        for (int i2 = 1; i2 < 65536; ++i2) {
            DSAParametersGenerator.inc((byte[])byArray3);
            DSAParametersGenerator.hash((Digest)digest, (byte[])byArray3, (byte[])byArray4, (int)0);
            BigInteger bigInteger4 = new BigInteger(1, byArray4);
            BigInteger bigInteger5 = bigInteger4.modPow(bigInteger3, bigInteger);
            if (bigInteger5.compareTo(TWO) < 0) continue;
            return bigInteger5;
        }
        return null;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n2) {
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, n2);
    }

    private static int getDefaultN(int n2) {
        return n2 > 1024 ? 256 : 160;
    }

    private static int getMinimumIterations(int n2) {
        return n2 <= 1024 ? 40 : 48 + 8 * ((n2 - 1) / 1024);
    }

    private static void inc(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byte by2;
            byArray[i2] = by2 = (byte)(byArray[i2] + 1 & 0xFF);
            if (by2 != 0) break;
        }
    }
}

