/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.DHParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.WNafUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.BigIntegers;

class DHKeyGeneratorHelper {
    static final DHKeyGeneratorHelper INSTANCE = new DHKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DHKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DHParameters dHParameters, SecureRandom secureRandom) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n2 = dHParameters.getL();
        if (n2 != 0) {
            BigInteger bigInteger3;
            int n3 = n2 >>> 2;
            while (WNafUtil.getNafWeight((BigInteger)(bigInteger3 = new BigInteger(n2, secureRandom).setBit(n2 - 1))) < n3) {
            }
            return bigInteger3;
        }
        BigInteger bigInteger4 = TWO;
        int n4 = dHParameters.getM();
        if (n4 != 0) {
            bigInteger4 = ONE.shiftLeft(n4 - 1);
        }
        if ((bigInteger2 = dHParameters.getQ()) == null) {
            bigInteger2 = dHParameters.getP();
        }
        BigInteger bigInteger5 = bigInteger2.subtract(TWO);
        int n5 = bigInteger5.bitLength() >>> 2;
        while (WNafUtil.getNafWeight((BigInteger)(bigInteger = BigIntegers.createRandomInRange((BigInteger)bigInteger4, (BigInteger)bigInteger5, (SecureRandom)secureRandom))) < n5) {
        }
        return bigInteger;
    }

    BigInteger calculatePublic(DHParameters dHParameters, BigInteger bigInteger) {
        return dHParameters.getG().modPow(bigInteger, dHParameters.getP());
    }
}

