/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.InvalidCipherTextException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Wrapper;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.engines.GOST28147Engine;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.macs.GOST28147Mac;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.KeyParameter;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithIV;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithSBox;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ParametersWithUKM;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class GOST28147WrapEngine
implements Wrapper {
    private GOST28147Engine cipher = new GOST28147Engine();
    private GOST28147Mac mac = new GOST28147Mac();

    public void init(boolean bl2, CipherParameters cipherParameters) {
        ParametersWithRandom parametersWithRandom;
        if (cipherParameters instanceof ParametersWithRandom) {
            parametersWithRandom = (ParametersWithRandom)cipherParameters;
            cipherParameters = parametersWithRandom.getParameters();
        }
        parametersWithRandom = (ParametersWithUKM)cipherParameters;
        this.cipher.init(bl2, parametersWithRandom.getParameters());
        KeyParameter keyParameter = parametersWithRandom.getParameters() instanceof ParametersWithSBox ? (KeyParameter)((ParametersWithSBox)parametersWithRandom.getParameters()).getParameters() : (KeyParameter)parametersWithRandom.getParameters();
        this.mac.init((CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, parametersWithRandom.getUKM()));
    }

    public String getAlgorithmName() {
        return "GOST28147Wrap";
    }

    public byte[] wrap(byte[] byArray, int n2, int n3) {
        this.mac.update(byArray, n2, n3);
        byte[] byArray2 = new byte[n3 + this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        this.mac.doFinal(byArray2, n3);
        return byArray2;
    }

    public byte[] unwrap(byte[] byArray, int n2, int n3) throws InvalidCipherTextException {
        byte[] byArray2 = new byte[n3 - this.mac.getMacSize()];
        this.cipher.processBlock(byArray, n2, byArray2, 0);
        this.cipher.processBlock(byArray, n2 + 8, byArray2, 8);
        this.cipher.processBlock(byArray, n2 + 16, byArray2, 16);
        this.cipher.processBlock(byArray, n2 + 24, byArray2, 24);
        byte[] byArray3 = new byte[this.mac.getMacSize()];
        this.mac.update(byArray2, 0, byArray2.length);
        this.mac.doFinal(byArray3, 0);
        byte[] byArray4 = new byte[this.mac.getMacSize()];
        System.arraycopy(byArray, n2 + n3 - 4, byArray4, 0, this.mac.getMacSize());
        if (!Arrays.constantTimeAreEqual((byte[])byArray3, (byte[])byArray4)) {
            throw new IllegalStateException("mac mismatch");
        }
        return byArray2;
    }
}

