/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.kdf;

import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DataLengthException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DerivationParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.DigestDerivationFunction;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.kdf.GSKKDFParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Pack;

public class GSKKFDGenerator
implements DigestDerivationFunction {
    private final Digest digest;
    private byte[] z;
    private int counter;
    private byte[] r;
    private byte[] buf;

    public GSKKFDGenerator(Digest digest) {
        this.digest = digest;
        this.buf = new byte[digest.getDigestSize()];
    }

    public Digest getDigest() {
        return this.digest;
    }

    public void init(DerivationParameters derivationParameters) {
        if (!(derivationParameters instanceof GSKKDFParameters)) {
            throw new IllegalArgumentException("unkown parameters type");
        }
        this.z = ((GSKKDFParameters)derivationParameters).getZ();
        this.counter = ((GSKKDFParameters)derivationParameters).getStartCounter();
        this.r = ((GSKKDFParameters)derivationParameters).getNonce();
    }

    public int generateBytes(byte[] byArray, int n2, int n3) throws DataLengthException, IllegalArgumentException {
        if (n2 + n3 > byArray.length) {
            throw new DataLengthException("output buffer too small");
        }
        this.digest.update(this.z, 0, this.z.length);
        byte[] byArray2 = Pack.intToBigEndian((int)this.counter++);
        this.digest.update(byArray2, 0, byArray2.length);
        if (this.r != null) {
            this.digest.update(this.r, 0, this.r.length);
        }
        this.digest.doFinal(this.buf, 0);
        System.arraycopy(this.buf, 0, byArray, n2, n3);
        Arrays.clear((byte[])this.buf);
        return n3;
    }
}

