/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake;

import java.math.BigInteger;
import java.security.SecureRandom;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoException;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CryptoServicesRegistrar;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake.JPAKEPrimeOrderGroup;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake.JPAKEPrimeOrderGroups;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake.JPAKERound1Payload;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake.JPAKERound2Payload;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake.JPAKERound3Payload;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement.jpake.JPAKEUtil;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.digests.SHA256Digest;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class JPAKEParticipant {
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_ROUND_1_CREATED = 10;
    public static final int STATE_ROUND_1_VALIDATED = 20;
    public static final int STATE_ROUND_2_CREATED = 30;
    public static final int STATE_ROUND_2_VALIDATED = 40;
    public static final int STATE_KEY_CALCULATED = 50;
    public static final int STATE_ROUND_3_CREATED = 60;
    public static final int STATE_ROUND_3_VALIDATED = 70;
    private final String participantId;
    private char[] password;
    private final Digest digest;
    private final SecureRandom random;
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger g;
    private String partnerParticipantId;
    private BigInteger x1;
    private BigInteger x2;
    private BigInteger gx1;
    private BigInteger gx2;
    private BigInteger gx3;
    private BigInteger gx4;
    private BigInteger b;
    private int state;

    public JPAKEParticipant(String string, char[] cArray) {
        this(string, cArray, JPAKEPrimeOrderGroups.NIST_3072);
    }

    public JPAKEParticipant(String string, char[] cArray, JPAKEPrimeOrderGroup jPAKEPrimeOrderGroup) {
        this(string, cArray, jPAKEPrimeOrderGroup, (Digest)new SHA256Digest(), CryptoServicesRegistrar.getSecureRandom());
    }

    public JPAKEParticipant(String string, char[] cArray, JPAKEPrimeOrderGroup jPAKEPrimeOrderGroup, Digest digest, SecureRandom secureRandom) {
        JPAKEUtil.validateNotNull((Object)string, (String)"participantId");
        JPAKEUtil.validateNotNull((Object)cArray, (String)"password");
        JPAKEUtil.validateNotNull((Object)jPAKEPrimeOrderGroup, (String)"p");
        JPAKEUtil.validateNotNull((Object)digest, (String)"digest");
        JPAKEUtil.validateNotNull((Object)secureRandom, (String)"random");
        if (cArray.length == 0) {
            throw new IllegalArgumentException("Password must not be empty.");
        }
        this.participantId = string;
        this.password = Arrays.copyOf((char[])cArray, (int)cArray.length);
        this.p = jPAKEPrimeOrderGroup.getP();
        this.q = jPAKEPrimeOrderGroup.getQ();
        this.g = jPAKEPrimeOrderGroup.getG();
        this.digest = digest;
        this.random = secureRandom;
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public JPAKERound1Payload createRound1PayloadToSend() {
        if (this.state >= 10) {
            throw new IllegalStateException("Round1 payload already created for " + this.participantId);
        }
        this.x1 = JPAKEUtil.generateX1((BigInteger)this.q, (SecureRandom)this.random);
        this.x2 = JPAKEUtil.generateX2((BigInteger)this.q, (SecureRandom)this.random);
        this.gx1 = JPAKEUtil.calculateGx((BigInteger)this.p, (BigInteger)this.g, (BigInteger)this.x1);
        this.gx2 = JPAKEUtil.calculateGx((BigInteger)this.p, (BigInteger)this.g, (BigInteger)this.x2);
        BigInteger[] bigIntegerArray = JPAKEUtil.calculateZeroKnowledgeProof((BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.g, (BigInteger)this.gx1, (BigInteger)this.x1, (String)this.participantId, (Digest)this.digest, (SecureRandom)this.random);
        BigInteger[] bigIntegerArray2 = JPAKEUtil.calculateZeroKnowledgeProof((BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.g, (BigInteger)this.gx2, (BigInteger)this.x2, (String)this.participantId, (Digest)this.digest, (SecureRandom)this.random);
        this.state = 10;
        return new JPAKERound1Payload(this.participantId, this.gx1, this.gx2, bigIntegerArray, bigIntegerArray2);
    }

    public void validateRound1PayloadReceived(JPAKERound1Payload jPAKERound1Payload) throws CryptoException {
        if (this.state >= 20) {
            throw new IllegalStateException("Validation already attempted for round1 payload for" + this.participantId);
        }
        this.partnerParticipantId = jPAKERound1Payload.getParticipantId();
        this.gx3 = jPAKERound1Payload.getGx1();
        this.gx4 = jPAKERound1Payload.getGx2();
        BigInteger[] bigIntegerArray = jPAKERound1Payload.getKnowledgeProofForX1();
        BigInteger[] bigIntegerArray2 = jPAKERound1Payload.getKnowledgeProofForX2();
        JPAKEUtil.validateParticipantIdsDiffer((String)this.participantId, (String)jPAKERound1Payload.getParticipantId());
        JPAKEUtil.validateGx4((BigInteger)this.gx4);
        JPAKEUtil.validateZeroKnowledgeProof((BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.g, (BigInteger)this.gx3, (BigInteger[])bigIntegerArray, (String)jPAKERound1Payload.getParticipantId(), (Digest)this.digest);
        JPAKEUtil.validateZeroKnowledgeProof((BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.g, (BigInteger)this.gx4, (BigInteger[])bigIntegerArray2, (String)jPAKERound1Payload.getParticipantId(), (Digest)this.digest);
        this.state = 20;
    }

    public JPAKERound2Payload createRound2PayloadToSend() {
        if (this.state >= 30) {
            throw new IllegalStateException("Round2 payload already created for " + this.participantId);
        }
        if (this.state < 20) {
            throw new IllegalStateException("Round1 payload must be validated prior to creating Round2 payload for " + this.participantId);
        }
        BigInteger bigInteger = JPAKEUtil.calculateGA((BigInteger)this.p, (BigInteger)this.gx1, (BigInteger)this.gx3, (BigInteger)this.gx4);
        BigInteger bigInteger2 = JPAKEUtil.calculateS((char[])this.password);
        BigInteger bigInteger3 = JPAKEUtil.calculateX2s((BigInteger)this.q, (BigInteger)this.x2, (BigInteger)bigInteger2);
        BigInteger bigInteger4 = JPAKEUtil.calculateA((BigInteger)this.p, (BigInteger)this.q, (BigInteger)bigInteger, (BigInteger)bigInteger3);
        BigInteger[] bigIntegerArray = JPAKEUtil.calculateZeroKnowledgeProof((BigInteger)this.p, (BigInteger)this.q, (BigInteger)bigInteger, (BigInteger)bigInteger4, (BigInteger)bigInteger3, (String)this.participantId, (Digest)this.digest, (SecureRandom)this.random);
        this.state = 30;
        return new JPAKERound2Payload(this.participantId, bigInteger4, bigIntegerArray);
    }

    public void validateRound2PayloadReceived(JPAKERound2Payload jPAKERound2Payload) throws CryptoException {
        if (this.state >= 40) {
            throw new IllegalStateException("Validation already attempted for round2 payload for" + this.participantId);
        }
        if (this.state < 20) {
            throw new IllegalStateException("Round1 payload must be validated prior to validating Round2 payload for " + this.participantId);
        }
        BigInteger bigInteger = JPAKEUtil.calculateGA((BigInteger)this.p, (BigInteger)this.gx3, (BigInteger)this.gx1, (BigInteger)this.gx2);
        this.b = jPAKERound2Payload.getA();
        BigInteger[] bigIntegerArray = jPAKERound2Payload.getKnowledgeProofForX2s();
        JPAKEUtil.validateParticipantIdsDiffer((String)this.participantId, (String)jPAKERound2Payload.getParticipantId());
        JPAKEUtil.validateParticipantIdsEqual((String)this.partnerParticipantId, (String)jPAKERound2Payload.getParticipantId());
        JPAKEUtil.validateGa((BigInteger)bigInteger);
        JPAKEUtil.validateZeroKnowledgeProof((BigInteger)this.p, (BigInteger)this.q, (BigInteger)bigInteger, (BigInteger)this.b, (BigInteger[])bigIntegerArray, (String)jPAKERound2Payload.getParticipantId(), (Digest)this.digest);
        this.state = 40;
    }

    public BigInteger calculateKeyingMaterial() {
        if (this.state >= 50) {
            throw new IllegalStateException("Key already calculated for " + this.participantId);
        }
        if (this.state < 40) {
            throw new IllegalStateException("Round2 payload must be validated prior to creating key for " + this.participantId);
        }
        BigInteger bigInteger = JPAKEUtil.calculateS((char[])this.password);
        Arrays.fill((char[])this.password, (char)'\u0000');
        this.password = null;
        BigInteger bigInteger2 = JPAKEUtil.calculateKeyingMaterial((BigInteger)this.p, (BigInteger)this.q, (BigInteger)this.gx4, (BigInteger)this.x2, (BigInteger)bigInteger, (BigInteger)this.b);
        this.x1 = null;
        this.x2 = null;
        this.b = null;
        this.state = 50;
        return bigInteger2;
    }

    public JPAKERound3Payload createRound3PayloadToSend(BigInteger bigInteger) {
        if (this.state >= 60) {
            throw new IllegalStateException("Round3 payload already created for " + this.participantId);
        }
        if (this.state < 50) {
            throw new IllegalStateException("Keying material must be calculated prior to creating Round3 payload for " + this.participantId);
        }
        BigInteger bigInteger2 = JPAKEUtil.calculateMacTag((String)this.participantId, (String)this.partnerParticipantId, (BigInteger)this.gx1, (BigInteger)this.gx2, (BigInteger)this.gx3, (BigInteger)this.gx4, (BigInteger)bigInteger, (Digest)this.digest);
        this.state = 60;
        return new JPAKERound3Payload(this.participantId, bigInteger2);
    }

    public void validateRound3PayloadReceived(JPAKERound3Payload jPAKERound3Payload, BigInteger bigInteger) throws CryptoException {
        if (this.state >= 70) {
            throw new IllegalStateException("Validation already attempted for round3 payload for" + this.participantId);
        }
        if (this.state < 50) {
            throw new IllegalStateException("Keying material must be calculated validated prior to validating Round3 payload for " + this.participantId);
        }
        JPAKEUtil.validateParticipantIdsDiffer((String)this.participantId, (String)jPAKERound3Payload.getParticipantId());
        JPAKEUtil.validateParticipantIdsEqual((String)this.partnerParticipantId, (String)jPAKERound3Payload.getParticipantId());
        JPAKEUtil.validateMacTag((String)this.participantId, (String)this.partnerParticipantId, (BigInteger)this.gx1, (BigInteger)this.gx2, (BigInteger)this.gx3, (BigInteger)this.gx4, (BigInteger)bigInteger, (Digest)this.digest, (BigInteger)jPAKERound3Payload.getMacTag());
        this.gx1 = null;
        this.gx2 = null;
        this.gx3 = null;
        this.gx4 = null;
        this.state = 70;
    }
}

