/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.crypto.agreement;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.BasicAgreement;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.CipherParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECDomainParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPrivateKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.crypto.params.ECPublicKeyParameters;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECAlgorithms;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECConstants;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECCurve;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECPoint;

public class ECDHBasicAgreement
implements BasicAgreement {
    private ECPrivateKeyParameters key;

    public void init(CipherParameters cipherParameters) {
        this.key = (ECPrivateKeyParameters)cipherParameters;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        ECPoint eCPoint;
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)cipherParameters;
        ECDomainParameters eCDomainParameters = this.key.getParameters();
        if (!eCDomainParameters.equals((Object)eCPublicKeyParameters.getParameters())) {
            throw new IllegalStateException("ECDH public key has wrong domain parameters");
        }
        BigInteger bigInteger = this.key.getD();
        ECPoint eCPoint2 = ECAlgorithms.cleanPoint((ECCurve)eCDomainParameters.getCurve(), (ECPoint)eCPublicKeyParameters.getQ());
        if (eCPoint2.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDH");
        }
        BigInteger bigInteger2 = eCDomainParameters.getH();
        if (!bigInteger2.equals(ECConstants.ONE)) {
            bigInteger = eCDomainParameters.getHInv().multiply(bigInteger).mod(eCDomainParameters.getN());
            eCPoint2 = ECAlgorithms.referenceMultiply((ECPoint)eCPoint2, (BigInteger)bigInteger2);
        }
        if ((eCPoint = eCPoint2.multiply(bigInteger).normalize()).isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDH");
        }
        return eCPoint.getAffineXCoord().toBigInteger();
    }
}

