/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x9.X9IntegerConverter;
import macromedia.externals.org.bouncycastle_1_60_0_0.math.ec.ECFieldElement;

public class X9FieldElement
extends ASN1Object {
    protected ECFieldElement f;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement eCFieldElement) {
        this.f = eCFieldElement;
    }

    public X9FieldElement(BigInteger bigInteger, ASN1OctetString aSN1OctetString) {
        this((ECFieldElement)new ECFieldElement.Fp(bigInteger, new BigInteger(1, aSN1OctetString.getOctets())));
    }

    public X9FieldElement(int n2, int n3, int n4, int n5, ASN1OctetString aSN1OctetString) {
        this((ECFieldElement)new ECFieldElement.F2m(n2, n3, n4, n5, new BigInteger(1, aSN1OctetString.getOctets())));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    public ASN1Primitive toASN1Primitive() {
        int n2 = converter.getByteLength(this.f);
        byte[] byArray = converter.integerToBytes(this.f.toBigInteger(), n2);
        return new DEROctetString(byArray);
    }
}

