/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.sigi;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Choice;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1String;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x500.DirectoryString;

public class NameOrPseudonym
extends ASN1Object
implements ASN1Choice {
    private DirectoryString pseudonym;
    private DirectoryString surname;
    private ASN1Sequence givenName;

    public static NameOrPseudonym getInstance(Object object) {
        if (object == null || object instanceof NameOrPseudonym) {
            return (NameOrPseudonym)object;
        }
        if (object instanceof ASN1String) {
            return new NameOrPseudonym(DirectoryString.getInstance((Object)object));
        }
        if (object instanceof ASN1Sequence) {
            return new NameOrPseudonym((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public NameOrPseudonym(DirectoryString directoryString) {
        this.pseudonym = directoryString;
    }

    private NameOrPseudonym(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        if (!(aSN1Sequence.getObjectAt(0) instanceof ASN1String)) {
            throw new IllegalArgumentException("Bad object encountered: " + aSN1Sequence.getObjectAt(0).getClass());
        }
        this.surname = DirectoryString.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.givenName = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
    }

    public NameOrPseudonym(String string) {
        this(new DirectoryString(string));
    }

    public NameOrPseudonym(DirectoryString directoryString, ASN1Sequence aSN1Sequence) {
        this.surname = directoryString;
        this.givenName = aSN1Sequence;
    }

    public DirectoryString getPseudonym() {
        return this.pseudonym;
    }

    public DirectoryString getSurname() {
        return this.surname;
    }

    public DirectoryString[] getGivenName() {
        DirectoryString[] directoryStringArray = new DirectoryString[this.givenName.size()];
        int n2 = 0;
        Enumeration enumeration = this.givenName.getObjects();
        while (enumeration.hasMoreElements()) {
            directoryStringArray[n2++] = DirectoryString.getInstance(enumeration.nextElement());
        }
        return directoryStringArray;
    }

    public ASN1Primitive toASN1Primitive() {
        if (this.pseudonym != null) {
            return this.pseudonym.toASN1Primitive();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.surname);
        aSN1EncodableVector.add((ASN1Encodable)this.givenName);
        return new DERSequence(aSN1EncodableVector);
    }
}

