/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509;

import java.io.IOException;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1UTCTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x500.X500Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.CRLReason;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extension;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.TBSCertList;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Time;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Name;

/*
 * Exception performing whole class analysis ignored.
 */
public class V2TBSCertListGenerator {
    private ASN1Integer version = new ASN1Integer(1L);
    private AlgorithmIdentifier signature;
    private X500Name issuer;
    private Time thisUpdate;
    private Time nextUpdate = null;
    private Extensions extensions = null;
    private ASN1EncodableVector crlentries = new ASN1EncodableVector();
    private static final ASN1Sequence[] reasons = new ASN1Sequence[11];

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(X509Name x509Name) {
        this.issuer = X500Name.getInstance((Object)x509Name.toASN1Primitive());
    }

    public void setIssuer(X500Name x500Name) {
        this.issuer = x500Name;
    }

    public void setThisUpdate(ASN1UTCTime aSN1UTCTime) {
        this.thisUpdate = new Time((ASN1Primitive)aSN1UTCTime);
    }

    public void setNextUpdate(ASN1UTCTime aSN1UTCTime) {
        this.nextUpdate = new Time((ASN1Primitive)aSN1UTCTime);
    }

    public void setThisUpdate(Time time) {
        this.thisUpdate = time;
    }

    public void setNextUpdate(Time time) {
        this.nextUpdate = time;
    }

    public void addCRLEntry(ASN1Sequence aSN1Sequence) {
        this.crlentries.add((ASN1Encodable)aSN1Sequence);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, ASN1UTCTime aSN1UTCTime, int n2) {
        this.addCRLEntry(aSN1Integer, new Time((ASN1Primitive)aSN1UTCTime), n2);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n2) {
        this.addCRLEntry(aSN1Integer, time, n2, null);
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, int n2, ASN1GeneralizedTime aSN1GeneralizedTime) {
        if (n2 != 0) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            if (n2 < reasons.length) {
                if (n2 < 0) {
                    throw new IllegalArgumentException("invalid reason value: " + n2);
                }
                aSN1EncodableVector.add((ASN1Encodable)reasons[n2]);
            } else {
                aSN1EncodableVector.add((ASN1Encodable)V2TBSCertListGenerator.createReasonExtension((int)n2));
            }
            if (aSN1GeneralizedTime != null) {
                aSN1EncodableVector.add((ASN1Encodable)V2TBSCertListGenerator.createInvalidityDateExtension((ASN1GeneralizedTime)aSN1GeneralizedTime));
            }
            this.internalAddCRLEntry(aSN1Integer, time, (ASN1Sequence)new DERSequence(aSN1EncodableVector));
        } else if (aSN1GeneralizedTime != null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((ASN1Encodable)V2TBSCertListGenerator.createInvalidityDateExtension((ASN1GeneralizedTime)aSN1GeneralizedTime));
            this.internalAddCRLEntry(aSN1Integer, time, (ASN1Sequence)new DERSequence(aSN1EncodableVector));
        } else {
            this.addCRLEntry(aSN1Integer, time, null);
        }
    }

    private void internalAddCRLEntry(ASN1Integer aSN1Integer, Time time, ASN1Sequence aSN1Sequence) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)aSN1Integer);
        aSN1EncodableVector.add((ASN1Encodable)time);
        if (aSN1Sequence != null) {
            aSN1EncodableVector.add((ASN1Encodable)aSN1Sequence);
        }
        this.addCRLEntry((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    public void addCRLEntry(ASN1Integer aSN1Integer, Time time, Extensions extensions) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)aSN1Integer);
        aSN1EncodableVector.add((ASN1Encodable)time);
        if (extensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)extensions);
        }
        this.addCRLEntry((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    public void setExtensions(X509Extensions x509Extensions) {
        this.setExtensions(Extensions.getInstance((Object)x509Extensions));
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.signature == null || this.issuer == null || this.thisUpdate == null) {
            throw new IllegalStateException("Not all mandatory fields set in V2 TBSCertList generator.");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        aSN1EncodableVector.add((ASN1Encodable)this.signature);
        aSN1EncodableVector.add((ASN1Encodable)this.issuer);
        aSN1EncodableVector.add((ASN1Encodable)this.thisUpdate);
        if (this.nextUpdate != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.nextUpdate);
        }
        if (this.crlentries.size() != 0) {
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(this.crlentries));
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)this.extensions));
        }
        return new TBSCertList((ASN1Sequence)new DERSequence(aSN1EncodableVector));
    }

    private static ASN1Sequence createReasonExtension(int n2) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        CRLReason cRLReason = CRLReason.lookup((int)n2);
        try {
            aSN1EncodableVector.add((ASN1Encodable)Extension.reasonCode);
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(cRLReason.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static ASN1Sequence createInvalidityDateExtension(ASN1GeneralizedTime aSN1GeneralizedTime) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            aSN1EncodableVector.add((ASN1Encodable)Extension.invalidityDate);
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(aSN1GeneralizedTime.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    static {
        V2TBSCertListGenerator.reasons[0] = V2TBSCertListGenerator.createReasonExtension((int)0);
        V2TBSCertListGenerator.reasons[1] = V2TBSCertListGenerator.createReasonExtension((int)1);
        V2TBSCertListGenerator.reasons[2] = V2TBSCertListGenerator.createReasonExtension((int)2);
        V2TBSCertListGenerator.reasons[3] = V2TBSCertListGenerator.createReasonExtension((int)3);
        V2TBSCertListGenerator.reasons[4] = V2TBSCertListGenerator.createReasonExtension((int)4);
        V2TBSCertListGenerator.reasons[5] = V2TBSCertListGenerator.createReasonExtension((int)5);
        V2TBSCertListGenerator.reasons[6] = V2TBSCertListGenerator.createReasonExtension((int)6);
        V2TBSCertListGenerator.reasons[7] = V2TBSCertListGenerator.createReasonExtension((int)7);
        V2TBSCertListGenerator.reasons[8] = V2TBSCertListGenerator.createReasonExtension((int)8);
        V2TBSCertListGenerator.reasons[9] = V2TBSCertListGenerator.createReasonExtension((int)9);
        V2TBSCertListGenerator.reasons[10] = V2TBSCertListGenerator.createReasonExtension((int)10);
    }
}

