/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERBitString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSet;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AttCertIssuer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AttCertValidityPeriod;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Attribute;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AttributeCertificateInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Holder;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.X509Extensions;

public class V2AttributeCertificateInfoGenerator {
    private ASN1Integer version = new ASN1Integer(1L);
    private Holder holder;
    private AttCertIssuer issuer;
    private AlgorithmIdentifier signature;
    private ASN1Integer serialNumber;
    private ASN1EncodableVector attributes = new ASN1EncodableVector();
    private DERBitString issuerUniqueID;
    private Extensions extensions;
    private ASN1GeneralizedTime startDate;
    private ASN1GeneralizedTime endDate;

    public void setHolder(Holder holder) {
        this.holder = holder;
    }

    public void addAttribute(String string, ASN1Encodable aSN1Encodable) {
        this.attributes.add((ASN1Encodable)new Attribute(new ASN1ObjectIdentifier(string), (ASN1Set)new DERSet(aSN1Encodable)));
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add((ASN1Encodable)attribute);
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        this.serialNumber = aSN1Integer;
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public void setIssuer(AttCertIssuer attCertIssuer) {
        this.issuer = attCertIssuer;
    }

    public void setStartDate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.startDate = aSN1GeneralizedTime;
    }

    public void setEndDate(ASN1GeneralizedTime aSN1GeneralizedTime) {
        this.endDate = aSN1GeneralizedTime;
    }

    public void setIssuerUniqueID(DERBitString dERBitString) {
        this.issuerUniqueID = dERBitString;
    }

    public void setExtensions(X509Extensions x509Extensions) {
        this.extensions = Extensions.getInstance((Object)x509Extensions.toASN1Primitive());
    }

    public void setExtensions(Extensions extensions) {
        this.extensions = extensions;
    }

    public AttributeCertificateInfo generateAttributeCertificateInfo() {
        if (this.serialNumber == null || this.signature == null || this.issuer == null || this.startDate == null || this.endDate == null || this.holder == null || this.attributes == null) {
            throw new IllegalStateException("not all mandatory fields set in V2 AttributeCertificateInfo generator");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        aSN1EncodableVector.add((ASN1Encodable)this.holder);
        aSN1EncodableVector.add((ASN1Encodable)this.issuer);
        aSN1EncodableVector.add((ASN1Encodable)this.signature);
        aSN1EncodableVector.add((ASN1Encodable)this.serialNumber);
        AttCertValidityPeriod attCertValidityPeriod = new AttCertValidityPeriod(this.startDate, this.endDate);
        aSN1EncodableVector.add((ASN1Encodable)attCertValidityPeriod);
        aSN1EncodableVector.add((ASN1Encodable)new DERSequence(this.attributes));
        if (this.issuerUniqueID != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.issuerUniqueID);
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.extensions);
        }
        return AttributeCertificateInfo.getInstance((Object)new DERSequence(aSN1EncodableVector));
    }
}

