/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1UTCTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x500.X500Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.TBSCertList;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Time;

/*
 * Exception performing whole class analysis ignored.
 */
public class TBSCertList
extends ASN1Object {
    ASN1Integer version;
    AlgorithmIdentifier signature;
    X500Name issuer;
    Time thisUpdate;
    Time nextUpdate;
    ASN1Sequence revokedCertificates;
    Extensions crlExtensions;

    public static TBSCertList getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return TBSCertList.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)bl2));
    }

    public static TBSCertList getInstance(Object object) {
        if (object instanceof TBSCertList) {
            return (TBSCertList)object;
        }
        if (object != null) {
            return new TBSCertList(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public TBSCertList(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 3 || aSN1Sequence.size() > 7) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        int n2 = 0;
        this.version = aSN1Sequence.getObjectAt(n2) instanceof ASN1Integer ? ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(n2++)) : null;
        this.signature = AlgorithmIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        this.issuer = X500Name.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        this.thisUpdate = Time.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        if (n2 < aSN1Sequence.size() && (aSN1Sequence.getObjectAt(n2) instanceof ASN1UTCTime || aSN1Sequence.getObjectAt(n2) instanceof ASN1GeneralizedTime || aSN1Sequence.getObjectAt(n2) instanceof Time)) {
            this.nextUpdate = Time.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        if (n2 < aSN1Sequence.size() && !(aSN1Sequence.getObjectAt(n2) instanceof ASN1TaggedObject)) {
            this.revokedCertificates = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        }
        if (n2 < aSN1Sequence.size() && aSN1Sequence.getObjectAt(n2) instanceof ASN1TaggedObject) {
            this.crlExtensions = Extensions.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Sequence.getObjectAt(n2)), (boolean)true));
        }
    }

    public int getVersionNumber() {
        if (this.version == null) {
            return 1;
        }
        return this.version.getValue().intValue() + 1;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public Time getThisUpdate() {
        return this.thisUpdate;
    }

    public Time getNextUpdate() {
        return this.nextUpdate;
    }

    public CRLEntry[] getRevokedCertificates() {
        if (this.revokedCertificates == null) {
            return new CRLEntry[0];
        }
        CRLEntry[] cRLEntryArray = new CRLEntry[this.revokedCertificates.size()];
        for (int i2 = 0; i2 < cRLEntryArray.length; ++i2) {
            cRLEntryArray[i2] = CRLEntry.getInstance((Object)this.revokedCertificates.getObjectAt(i2));
        }
        return cRLEntryArray;
    }

    public Enumeration getRevokedCertificateEnumeration() {
        if (this.revokedCertificates == null) {
            return new EmptyEnumeration(this, null);
        }
        return new RevokedCertificatesEnumeration(this, this.revokedCertificates.getObjects());
    }

    public Extensions getExtensions() {
        return this.crlExtensions;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.version);
        }
        aSN1EncodableVector.add((ASN1Encodable)this.signature);
        aSN1EncodableVector.add((ASN1Encodable)this.issuer);
        aSN1EncodableVector.add((ASN1Encodable)this.thisUpdate);
        if (this.nextUpdate != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.nextUpdate);
        }
        if (this.revokedCertificates != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.revokedCertificates);
        }
        if (this.crlExtensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)this.crlExtensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

