/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.tsp;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Boolean;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.tsp.MessageImprint;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;

public class TimeStampReq
extends ASN1Object {
    ASN1Integer version;
    MessageImprint messageImprint;
    ASN1ObjectIdentifier tsaPolicy;
    ASN1Integer nonce;
    ASN1Boolean certReq;
    Extensions extensions;

    public static TimeStampReq getInstance(Object object) {
        if (object instanceof TimeStampReq) {
            return (TimeStampReq)object;
        }
        if (object != null) {
            return new TimeStampReq(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private TimeStampReq(ASN1Sequence aSN1Sequence) {
        int n2 = aSN1Sequence.size();
        int n3 = 0;
        this.version = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(n3));
        this.messageImprint = MessageImprint.getInstance((Object)aSN1Sequence.getObjectAt(++n3));
        for (int i2 = ++n3; i2 < n2; ++i2) {
            ASN1TaggedObject aSN1TaggedObject;
            if (aSN1Sequence.getObjectAt(i2) instanceof ASN1ObjectIdentifier) {
                this.tsaPolicy = ASN1ObjectIdentifier.getInstance((Object)aSN1Sequence.getObjectAt(i2));
                continue;
            }
            if (aSN1Sequence.getObjectAt(i2) instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(i2));
                continue;
            }
            if (aSN1Sequence.getObjectAt(i2) instanceof ASN1Boolean) {
                this.certReq = ASN1Boolean.getInstance((Object)aSN1Sequence.getObjectAt(i2));
                continue;
            }
            if (!(aSN1Sequence.getObjectAt(i2) instanceof ASN1TaggedObject) || (aSN1TaggedObject = (ASN1TaggedObject)aSN1Sequence.getObjectAt(i2)).getTagNo() != 0) continue;
            this.extensions = Extensions.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
        }
    }

    public TimeStampReq(MessageImprint messageImprint, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Integer aSN1Integer, ASN1Boolean aSN1Boolean, Extensions extensions) {
        this.version = new ASN1Integer(1L);
        this.messageImprint = messageImprint;
        this.tsaPolicy = aSN1ObjectIdentifier;
        this.nonce = aSN1Integer;
        this.certReq = aSN1Boolean;
        this.extensions = extensions;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public MessageImprint getMessageImprint() {
        return this.messageImprint;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        return this.tsaPolicy;
    }

    public ASN1Integer getNonce() {
        return this.nonce;
    }

    public ASN1Boolean getCertReq() {
        return this.certReq;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        aSN1EncodableVector.add((ASN1Encodable)this.messageImprint);
        if (this.tsaPolicy != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.tsaPolicy);
        }
        if (this.nonce != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.nonce);
        }
        if (this.certReq != null && this.certReq.isTrue()) {
            aSN1EncodableVector.add((ASN1Encodable)this.certReq);
        }
        if (this.extensions != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.extensions));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

