/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERNull;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs.PKCSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class PBKDF2Params
extends ASN1Object {
    private static final AlgorithmIdentifier algid_hmacWithSHA1 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, (ASN1Encodable)DERNull.INSTANCE);
    private final ASN1OctetString octStr;
    private final ASN1Integer iterationCount;
    private final ASN1Integer keyLength;
    private final AlgorithmIdentifier prf;

    public static PBKDF2Params getInstance(Object object) {
        if (object instanceof PBKDF2Params) {
            return (PBKDF2Params)object;
        }
        if (object != null) {
            return new PBKDF2Params(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public PBKDF2Params(byte[] byArray, int n2) {
        this(byArray, n2, 0);
    }

    public PBKDF2Params(byte[] byArray, int n2, int n3) {
        this(byArray, n2, n3, null);
    }

    public PBKDF2Params(byte[] byArray, int n2, int n3, AlgorithmIdentifier algorithmIdentifier) {
        this.octStr = new DEROctetString(Arrays.clone((byte[])byArray));
        this.iterationCount = new ASN1Integer((long)n2);
        this.keyLength = n3 > 0 ? new ASN1Integer((long)n3) : null;
        this.prf = algorithmIdentifier;
    }

    public PBKDF2Params(byte[] byArray, int n2, AlgorithmIdentifier algorithmIdentifier) {
        this(byArray, n2, 0, algorithmIdentifier);
    }

    private PBKDF2Params(ASN1Sequence aSN1Sequence) {
        Enumeration enumeration = aSN1Sequence.getObjects();
        this.octStr = (ASN1OctetString)enumeration.nextElement();
        this.iterationCount = (ASN1Integer)enumeration.nextElement();
        if (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof ASN1Integer) {
                this.keyLength = ASN1Integer.getInstance(object);
                object = enumeration.hasMoreElements() ? enumeration.nextElement() : null;
            } else {
                this.keyLength = null;
            }
            this.prf = object != null ? AlgorithmIdentifier.getInstance(object) : null;
        } else {
            this.keyLength = null;
            this.prf = null;
        }
    }

    public byte[] getSalt() {
        return this.octStr.getOctets();
    }

    public BigInteger getIterationCount() {
        return this.iterationCount.getValue();
    }

    public BigInteger getKeyLength() {
        if (this.keyLength != null) {
            return this.keyLength.getValue();
        }
        return null;
    }

    public boolean isDefaultPrf() {
        return this.prf == null || this.prf.equals((Object)algid_hmacWithSHA1);
    }

    public AlgorithmIdentifier getPrf() {
        if (this.prf != null) {
            return this.prf;
        }
        return algid_hmacWithSHA1;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.octStr);
        aSN1EncodableVector.add((ASN1Encodable)this.iterationCount);
        if (this.keyLength != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.keyLength);
        }
        if (this.prf != null && !this.prf.equals((Object)algid_hmacWithSHA1)) {
            aSN1EncodableVector.add((ASN1Encodable)this.prf);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

