/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.pkcs;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AlgorithmIdentifier;

public class EncryptedData
extends ASN1Object {
    ASN1Sequence data;
    ASN1ObjectIdentifier bagId;
    ASN1Primitive bagValue;

    public static EncryptedData getInstance(Object object) {
        if (object instanceof EncryptedData) {
            return (EncryptedData)object;
        }
        if (object != null) {
            return new EncryptedData(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private EncryptedData(ASN1Sequence aSN1Sequence) {
        int n2 = ((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue().intValue();
        if (n2 != 0) {
            throw new IllegalArgumentException("sequence not version 0");
        }
        this.data = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
    }

    public EncryptedData(ASN1ObjectIdentifier aSN1ObjectIdentifier, AlgorithmIdentifier algorithmIdentifier, ASN1Encodable aSN1Encodable) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)aSN1ObjectIdentifier);
        aSN1EncodableVector.add((ASN1Encodable)algorithmIdentifier.toASN1Primitive());
        aSN1EncodableVector.add((ASN1Encodable)new BERTaggedObject(false, 0, aSN1Encodable));
        this.data = new BERSequence(aSN1EncodableVector);
    }

    public ASN1ObjectIdentifier getContentType() {
        return ASN1ObjectIdentifier.getInstance((Object)this.data.getObjectAt(0));
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return AlgorithmIdentifier.getInstance((Object)this.data.getObjectAt(1));
    }

    public ASN1OctetString getContent() {
        if (this.data.size() == 3) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)this.data.getObjectAt(2));
            return ASN1OctetString.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
        }
        return null;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(0L));
        aSN1EncodableVector.add((ASN1Encodable)this.data);
        return new BERSequence(aSN1EncodableVector);
    }
}

