/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ocsp;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x500.X500Name;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.AuthorityInformationAccess;

public class ServiceLocator
extends ASN1Object {
    private final X500Name issuer;
    private final AuthorityInformationAccess locator;

    private ServiceLocator(ASN1Sequence aSN1Sequence) {
        this.issuer = X500Name.getInstance((Object)aSN1Sequence.getObjectAt(0));
        this.locator = aSN1Sequence.size() == 2 ? AuthorityInformationAccess.getInstance((Object)aSN1Sequence.getObjectAt(1)) : null;
    }

    public static ServiceLocator getInstance(Object object) {
        if (object instanceof ServiceLocator) {
            return (ServiceLocator)object;
        }
        if (object != null) {
            return new ServiceLocator(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public AuthorityInformationAccess getLocator() {
        return this.locator;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.issuer);
        if (this.locator != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.locator);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

