/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.isismtt.x509;

import java.util.Enumeration;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.isismtt.x509.NamingAuthority;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.isismtt.x509.ProfessionInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralName;

public class Admissions
extends ASN1Object {
    private GeneralName admissionAuthority;
    private NamingAuthority namingAuthority;
    private ASN1Sequence professionInfos;

    public static Admissions getInstance(Object object) {
        if (object == null || object instanceof Admissions) {
            return (Admissions)object;
        }
        if (object instanceof ASN1Sequence) {
            return new Admissions((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    private Admissions(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        Enumeration enumeration = aSN1Sequence.getObjects();
        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            switch (((ASN1TaggedObject)aSN1Encodable).getTagNo()) {
                case 0: {
                    this.admissionAuthority = GeneralName.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)true);
                    break;
                }
                case 1: {
                    this.namingAuthority = NamingAuthority.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag number: " + ((ASN1TaggedObject)aSN1Encodable).getTagNo());
                }
            }
            aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        }
        if (aSN1Encodable instanceof ASN1TaggedObject) {
            switch (((ASN1TaggedObject)aSN1Encodable).getTagNo()) {
                case 1: {
                    this.namingAuthority = NamingAuthority.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Encodable), (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad tag number: " + ((ASN1TaggedObject)aSN1Encodable).getTagNo());
                }
            }
            aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        }
        this.professionInfos = ASN1Sequence.getInstance((Object)aSN1Encodable);
        if (enumeration.hasMoreElements()) {
            throw new IllegalArgumentException("Bad object encountered: " + enumeration.nextElement().getClass());
        }
    }

    public Admissions(GeneralName generalName, NamingAuthority namingAuthority, ProfessionInfo[] professionInfoArray) {
        this.admissionAuthority = generalName;
        this.namingAuthority = namingAuthority;
        this.professionInfos = new DERSequence((ASN1Encodable[])professionInfoArray);
    }

    public GeneralName getAdmissionAuthority() {
        return this.admissionAuthority;
    }

    public NamingAuthority getNamingAuthority() {
        return this.namingAuthority;
    }

    public ProfessionInfo[] getProfessionInfos() {
        ProfessionInfo[] professionInfoArray = new ProfessionInfo[this.professionInfos.size()];
        int n2 = 0;
        Enumeration enumeration = this.professionInfos.getObjects();
        while (enumeration.hasMoreElements()) {
            professionInfoArray[n2++] = ProfessionInfo.getInstance(enumeration.nextElement());
        }
        return professionInfoArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.admissionAuthority != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)this.admissionAuthority));
        }
        if (this.namingAuthority != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)this.namingAuthority));
        }
        aSN1EncodableVector.add((ASN1Encodable)this.professionInfos);
        return new DERSequence(aSN1EncodableVector);
    }
}

