/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ess;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ess.OtherCertID;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.PolicyInformation;

public class OtherSigningCertificate
extends ASN1Object {
    ASN1Sequence certs;
    ASN1Sequence policies;

    public static OtherSigningCertificate getInstance(Object object) {
        if (object instanceof OtherSigningCertificate) {
            return (OtherSigningCertificate)object;
        }
        if (object != null) {
            return new OtherSigningCertificate(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    private OtherSigningCertificate(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() < 1 || aSN1Sequence.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + aSN1Sequence.size());
        }
        this.certs = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() > 1) {
            this.policies = ASN1Sequence.getInstance((Object)aSN1Sequence.getObjectAt(1));
        }
    }

    public OtherSigningCertificate(OtherCertID otherCertID) {
        this.certs = new DERSequence((ASN1Encodable)otherCertID);
    }

    public OtherCertID[] getCerts() {
        OtherCertID[] otherCertIDArray = new OtherCertID[this.certs.size()];
        for (int i2 = 0; i2 != this.certs.size(); ++i2) {
            otherCertIDArray[i2] = OtherCertID.getInstance((Object)this.certs.getObjectAt(i2));
        }
        return otherCertIDArray;
    }

    public PolicyInformation[] getPolicies() {
        if (this.policies == null) {
            return null;
        }
        PolicyInformation[] policyInformationArray = new PolicyInformation[this.policies.size()];
        for (int i2 = 0; i2 != this.policies.size(); ++i2) {
            policyInformationArray[i2] = PolicyInformation.getInstance((Object)this.policies.getObjectAt(i2));
        }
        return policyInformationArray;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.certs);
        if (this.policies != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.policies);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

