/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.eac;

import java.io.IOException;
import java.util.Hashtable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1ObjectIdentifier;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERApplicationSpecific;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.eac.BidirectionalMap;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.eac.EACObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Integers;

public class CertificateHolderAuthorization
extends ASN1Object {
    ASN1ObjectIdentifier oid;
    DERApplicationSpecific accessRights;
    public static final ASN1ObjectIdentifier id_role_EAC = EACObjectIdentifiers.bsi_de.branch("3.1.2.1");
    public static final int CVCA = 192;
    public static final int DV_DOMESTIC = 128;
    public static final int DV_FOREIGN = 64;
    public static final int IS = 0;
    public static final int RADG4 = 2;
    public static final int RADG3 = 1;
    static Hashtable RightsDecodeMap = new Hashtable();
    static BidirectionalMap AuthorizationRole = new BidirectionalMap();
    static Hashtable ReverseMap = new Hashtable();

    public static String getRoleDescription(int n2) {
        return (String)AuthorizationRole.get((Object)Integers.valueOf((int)n2));
    }

    public static int getFlag(String string) {
        Integer n2 = (Integer)AuthorizationRole.getReverse((Object)string);
        if (n2 == null) {
            throw new IllegalArgumentException("Unknown value " + string);
        }
        return n2;
    }

    private void setPrivateData(ASN1InputStream aSN1InputStream) throws IOException {
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            throw new IllegalArgumentException("no Oid in CerticateHolderAuthorization");
        }
        this.oid = (ASN1ObjectIdentifier)aSN1Primitive;
        aSN1Primitive = aSN1InputStream.readObject();
        if (!(aSN1Primitive instanceof DERApplicationSpecific)) {
            throw new IllegalArgumentException("No access rights in CerticateHolderAuthorization");
        }
        this.accessRights = (DERApplicationSpecific)aSN1Primitive;
    }

    public CertificateHolderAuthorization(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n2) throws IOException {
        this.setOid(aSN1ObjectIdentifier);
        this.setAccessRights((byte)n2);
    }

    public CertificateHolderAuthorization(DERApplicationSpecific dERApplicationSpecific) throws IOException {
        if (dERApplicationSpecific.getApplicationTag() == 76) {
            this.setPrivateData(new ASN1InputStream(dERApplicationSpecific.getContents()));
        }
    }

    public int getAccessRights() {
        return this.accessRights.getContents()[0] & 0xFF;
    }

    private void setAccessRights(byte by2) {
        byte[] byArray = new byte[]{by2};
        this.accessRights = new DERApplicationSpecific(19, byArray);
    }

    public ASN1ObjectIdentifier getOid() {
        return this.oid;
    }

    private void setOid(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.oid = aSN1ObjectIdentifier;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.oid);
        aSN1EncodableVector.add((ASN1Encodable)this.accessRights);
        return new DERApplicationSpecific(76, aSN1EncodableVector);
    }

    static {
        RightsDecodeMap.put(Integers.valueOf((int)2), "RADG4");
        RightsDecodeMap.put(Integers.valueOf((int)1), "RADG3");
        AuthorizationRole.put((Object)Integers.valueOf((int)192), (Object)"CVCA");
        AuthorizationRole.put((Object)Integers.valueOf((int)128), (Object)"DV_DOMESTIC");
        AuthorizationRole.put((Object)Integers.valueOf((int)64), (Object)"DV_FOREIGN");
        AuthorizationRole.put((Object)Integers.valueOf((int)0), (Object)"IS");
    }
}

