/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.dvcs;

import java.math.BigInteger;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.dvcs.DVCSTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.dvcs.ServiceType;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.Extensions;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.GeneralNames;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.x509.PolicyInformation;

/*
 * Exception performing whole class analysis ignored.
 */
public class DVCSRequestInformation
extends ASN1Object {
    private int version = 1;
    private ServiceType service;
    private BigInteger nonce;
    private DVCSTime requestTime;
    private GeneralNames requester;
    private PolicyInformation requestPolicy;
    private GeneralNames dvcs;
    private GeneralNames dataLocations;
    private Extensions extensions;
    private static final int DEFAULT_VERSION = 1;
    private static final int TAG_REQUESTER = 0;
    private static final int TAG_REQUEST_POLICY = 1;
    private static final int TAG_DVCS = 2;
    private static final int TAG_DATA_LOCATIONS = 3;
    private static final int TAG_EXTENSIONS = 4;

    private DVCSRequestInformation(ASN1Sequence aSN1Sequence) {
        ASN1Integer aSN1Integer;
        int n2 = 0;
        if (aSN1Sequence.getObjectAt(0) instanceof ASN1Integer) {
            aSN1Integer = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
            this.version = aSN1Integer.getValue().intValue();
        } else {
            this.version = 1;
        }
        this.service = ServiceType.getInstance((Object)aSN1Sequence.getObjectAt(n2++));
        while (n2 < aSN1Sequence.size()) {
            aSN1Integer = aSN1Sequence.getObjectAt(n2);
            if (aSN1Integer instanceof ASN1Integer) {
                this.nonce = ASN1Integer.getInstance((Object)aSN1Integer).getValue();
            } else if (aSN1Integer instanceof ASN1GeneralizedTime) {
                this.requestTime = DVCSTime.getInstance((Object)aSN1Integer);
            } else if (aSN1Integer instanceof ASN1TaggedObject) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)aSN1Integer);
                int n3 = aSN1TaggedObject.getTagNo();
                switch (n3) {
                    case 0: {
                        this.requester = GeneralNames.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                        break;
                    }
                    case 1: {
                        this.requestPolicy = PolicyInformation.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false));
                        break;
                    }
                    case 2: {
                        this.dvcs = GeneralNames.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                        break;
                    }
                    case 3: {
                        this.dataLocations = GeneralNames.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                        break;
                    }
                    case 4: {
                        this.extensions = Extensions.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)false);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag number encountered: " + n3);
                    }
                }
            } else {
                this.requestTime = DVCSTime.getInstance((Object)aSN1Integer);
            }
            ++n2;
        }
    }

    public static DVCSRequestInformation getInstance(Object object) {
        if (object instanceof DVCSRequestInformation) {
            return (DVCSRequestInformation)object;
        }
        if (object != null) {
            return new DVCSRequestInformation(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public static DVCSRequestInformation getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return DVCSRequestInformation.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)bl2));
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.version != 1) {
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.version));
        }
        aSN1EncodableVector.add((ASN1Encodable)this.service);
        if (this.nonce != null) {
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(this.nonce));
        }
        if (this.requestTime != null) {
            aSN1EncodableVector.add((ASN1Encodable)this.requestTime);
        }
        int[] nArray = new int[]{0, 1, 2, 3, 4};
        ASN1Encodable[] aSN1EncodableArray = new ASN1Encodable[]{this.requester, this.requestPolicy, this.dvcs, this.dataLocations, this.extensions};
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            ASN1Encodable aSN1Encodable = aSN1EncodableArray[i2];
            if (aSN1Encodable == null) continue;
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, n2, aSN1Encodable));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DVCSRequestInformation {\n");
        if (this.version != 1) {
            stringBuffer.append("version: " + this.version + "\n");
        }
        stringBuffer.append("service: " + this.service + "\n");
        if (this.nonce != null) {
            stringBuffer.append("nonce: " + this.nonce + "\n");
        }
        if (this.requestTime != null) {
            stringBuffer.append("requestTime: " + this.requestTime + "\n");
        }
        if (this.requester != null) {
            stringBuffer.append("requester: " + this.requester + "\n");
        }
        if (this.requestPolicy != null) {
            stringBuffer.append("requestPolicy: " + this.requestPolicy + "\n");
        }
        if (this.dvcs != null) {
            stringBuffer.append("dvcs: " + this.dvcs + "\n");
        }
        if (this.dataLocations != null) {
            stringBuffer.append("dataLocations: " + this.dataLocations + "\n");
        }
        if (this.extensions != null) {
            stringBuffer.append("extensions: " + this.extensions + "\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public int getVersion() {
        return this.version;
    }

    public ServiceType getService() {
        return this.service;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public DVCSTime getRequestTime() {
        return this.requestTime;
    }

    public GeneralNames getRequester() {
        return this.requester;
    }

    public PolicyInformation getRequestPolicy() {
        return this.requestPolicy;
    }

    public GeneralNames getDVCS() {
        return this.dvcs;
    }

    public GeneralNames getDataLocations() {
        return this.dataLocations;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }
}

