/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Set;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.CMSObjectIdentifiers;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.EncryptedContentInfo;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cms.OriginatorInfo;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthEnvelopedData
extends ASN1Object {
    private ASN1Integer version;
    private OriginatorInfo originatorInfo;
    private ASN1Set recipientInfos;
    private EncryptedContentInfo authEncryptedContentInfo;
    private ASN1Set authAttrs;
    private ASN1OctetString mac;
    private ASN1Set unauthAttrs;

    public AuthEnvelopedData(OriginatorInfo originatorInfo, ASN1Set aSN1Set, EncryptedContentInfo encryptedContentInfo, ASN1Set aSN1Set2, ASN1OctetString aSN1OctetString, ASN1Set aSN1Set3) {
        this.version = new ASN1Integer(0L);
        this.originatorInfo = originatorInfo;
        this.recipientInfos = aSN1Set;
        if (this.recipientInfos.size() == 0) {
            throw new IllegalArgumentException("AuthEnvelopedData requires at least 1 RecipientInfo");
        }
        this.authEncryptedContentInfo = encryptedContentInfo;
        this.authAttrs = aSN1Set2;
        if (!(encryptedContentInfo.getContentType().equals((Object)CMSObjectIdentifiers.data) || aSN1Set2 != null && aSN1Set2.size() != 0)) {
            throw new IllegalArgumentException("authAttrs must be present with non-data content");
        }
        this.mac = aSN1OctetString;
        this.unauthAttrs = aSN1Set3;
    }

    private AuthEnvelopedData(ASN1Sequence aSN1Sequence) {
        int n2 = 0;
        ASN1Primitive aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        this.version = (ASN1Integer)aSN1Primitive;
        if (this.version.getValue().intValue() != 0) {
            throw new IllegalArgumentException("AuthEnvelopedData version number must be 0");
        }
        if ((aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive()) instanceof ASN1TaggedObject) {
            this.originatorInfo = OriginatorInfo.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Primitive), (boolean)false);
            aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        }
        this.recipientInfos = ASN1Set.getInstance((Object)aSN1Primitive);
        if (this.recipientInfos.size() == 0) {
            throw new IllegalArgumentException("AuthEnvelopedData requires at least 1 RecipientInfo");
        }
        aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        this.authEncryptedContentInfo = EncryptedContentInfo.getInstance((Object)aSN1Primitive);
        if ((aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive()) instanceof ASN1TaggedObject) {
            this.authAttrs = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Primitive), (boolean)false);
            aSN1Primitive = aSN1Sequence.getObjectAt(n2++).toASN1Primitive();
        } else if (!(this.authEncryptedContentInfo.getContentType().equals((Object)CMSObjectIdentifiers.data) || this.authAttrs != null && this.authAttrs.size() != 0)) {
            throw new IllegalArgumentException("authAttrs must be present with non-data content");
        }
        this.mac = ASN1OctetString.getInstance((Object)aSN1Primitive);
        if (aSN1Sequence.size() > n2) {
            aSN1Primitive = aSN1Sequence.getObjectAt(n2).toASN1Primitive();
            this.unauthAttrs = ASN1Set.getInstance((ASN1TaggedObject)((ASN1TaggedObject)aSN1Primitive), (boolean)false);
        }
    }

    public static AuthEnvelopedData getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl2) {
        return AuthEnvelopedData.getInstance((Object)ASN1Sequence.getInstance((ASN1TaggedObject)aSN1TaggedObject, (boolean)bl2));
    }

    public static AuthEnvelopedData getInstance(Object object) {
        if (object == null || object instanceof AuthEnvelopedData) {
            return (AuthEnvelopedData)object;
        }
        if (object instanceof ASN1Sequence) {
            return new AuthEnvelopedData((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid AuthEnvelopedData: " + object.getClass().getName());
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public ASN1Set getRecipientInfos() {
        return this.recipientInfos;
    }

    public EncryptedContentInfo getAuthEncryptedContentInfo() {
        return this.authEncryptedContentInfo;
    }

    public ASN1Set getAuthAttrs() {
        return this.authAttrs;
    }

    public ASN1OctetString getMac() {
        return this.mac;
    }

    public ASN1Set getUnauthAttrs() {
        return this.unauthAttrs;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.version);
        if (this.originatorInfo != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.originatorInfo));
        }
        aSN1EncodableVector.add((ASN1Encodable)this.recipientInfos);
        aSN1EncodableVector.add((ASN1Encodable)this.authEncryptedContentInfo);
        if (this.authAttrs != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)this.authAttrs));
        }
        aSN1EncodableVector.add((ASN1Encodable)this.mac);
        if (this.unauthAttrs != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 2, (ASN1Encodable)this.unauthAttrs));
        }
        return new BERSequence(aSN1EncodableVector);
    }
}

