/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp;

import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1TaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.cmp.CertOrEncCert;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf.EncryptedValue;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.crmf.PKIPublicationInfo;

public class CertifiedKeyPair
extends ASN1Object {
    private CertOrEncCert certOrEncCert;
    private EncryptedValue privateKey;
    private PKIPublicationInfo publicationInfo;

    private CertifiedKeyPair(ASN1Sequence aSN1Sequence) {
        this.certOrEncCert = CertOrEncCert.getInstance((Object)aSN1Sequence.getObjectAt(0));
        if (aSN1Sequence.size() >= 2) {
            if (aSN1Sequence.size() == 2) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(1));
                if (aSN1TaggedObject.getTagNo() == 0) {
                    this.privateKey = EncryptedValue.getInstance((Object)aSN1TaggedObject.getObject());
                } else {
                    this.publicationInfo = PKIPublicationInfo.getInstance((Object)aSN1TaggedObject.getObject());
                }
            } else {
                this.privateKey = EncryptedValue.getInstance((Object)ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(1)));
                this.publicationInfo = PKIPublicationInfo.getInstance((Object)ASN1TaggedObject.getInstance((Object)aSN1Sequence.getObjectAt(2)));
            }
        }
    }

    public static CertifiedKeyPair getInstance(Object object) {
        if (object instanceof CertifiedKeyPair) {
            return (CertifiedKeyPair)object;
        }
        if (object != null) {
            return new CertifiedKeyPair(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert) {
        this(certOrEncCert, null, null);
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert, EncryptedValue encryptedValue, PKIPublicationInfo pKIPublicationInfo) {
        if (certOrEncCert == null) {
            throw new IllegalArgumentException("'certOrEncCert' cannot be null");
        }
        this.certOrEncCert = certOrEncCert;
        this.privateKey = encryptedValue;
        this.publicationInfo = pKIPublicationInfo;
    }

    public CertOrEncCert getCertOrEncCert() {
        return this.certOrEncCert;
    }

    public EncryptedValue getPrivateKey() {
        return this.privateKey;
    }

    public PKIPublicationInfo getPublicationInfo() {
        return this.publicationInfo;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)this.certOrEncCert);
        if (this.privateKey != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)this.privateKey));
        }
        if (this.publicationInfo != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)this.publicationInfo));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

