/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1.bc;

import java.math.BigInteger;
import java.util.Date;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1GeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Integer;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Object;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1OctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Sequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERGeneralizedTime;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequence;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERUTF8String;
import macromedia.externals.org.bouncycastle_1_60_0_0.util.Arrays;

public class ObjectData
extends ASN1Object {
    private final BigInteger type;
    private final String identifier;
    private final ASN1GeneralizedTime creationDate;
    private final ASN1GeneralizedTime lastModifiedDate;
    private final ASN1OctetString data;
    private final String comment;

    private ObjectData(ASN1Sequence aSN1Sequence) {
        this.type = ASN1Integer.getInstance((Object)aSN1Sequence.getObjectAt(0)).getValue();
        this.identifier = DERUTF8String.getInstance((Object)aSN1Sequence.getObjectAt(1)).getString();
        this.creationDate = ASN1GeneralizedTime.getInstance((Object)aSN1Sequence.getObjectAt(2));
        this.lastModifiedDate = ASN1GeneralizedTime.getInstance((Object)aSN1Sequence.getObjectAt(3));
        this.data = ASN1OctetString.getInstance((Object)aSN1Sequence.getObjectAt(4));
        this.comment = aSN1Sequence.size() == 6 ? DERUTF8String.getInstance((Object)aSN1Sequence.getObjectAt(5)).getString() : null;
    }

    public ObjectData(BigInteger bigInteger, String string, Date date, Date date2, byte[] byArray, String string2) {
        this.type = bigInteger;
        this.identifier = string;
        this.creationDate = new DERGeneralizedTime(date);
        this.lastModifiedDate = new DERGeneralizedTime(date2);
        this.data = new DEROctetString(Arrays.clone((byte[])byArray));
        this.comment = string2;
    }

    public static ObjectData getInstance(Object object) {
        if (object instanceof ObjectData) {
            return (ObjectData)object;
        }
        if (object != null) {
            return new ObjectData(ASN1Sequence.getInstance((Object)object));
        }
        return null;
    }

    public String getComment() {
        return this.comment;
    }

    public ASN1GeneralizedTime getCreationDate() {
        return this.creationDate;
    }

    public byte[] getData() {
        return Arrays.clone((byte[])this.data.getOctets());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ASN1GeneralizedTime getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public BigInteger getType() {
        return this.type;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer(this.type));
        aSN1EncodableVector.add((ASN1Encodable)new DERUTF8String(this.identifier));
        aSN1EncodableVector.add((ASN1Encodable)this.creationDate);
        aSN1EncodableVector.add((ASN1Encodable)this.lastModifiedDate);
        aSN1EncodableVector.add((ASN1Encodable)this.data);
        if (this.comment != null) {
            aSN1EncodableVector.add((ASN1Encodable)new DERUTF8String(this.comment));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

