/*
 * Decompiled with CFR 0.152.
 */
package macromedia.externals.org.bouncycastle_1_60_0_0.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Encodable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1EncodableVector;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Exception;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1InputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.ASN1Primitive;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERApplicationSpecificParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BEROctetStringParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERSequenceParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERSetParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.BERTaggedObjectParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERApplicationSpecific;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERExternalParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERFactory;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetString;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DEROctetStringParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSequenceParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERSetParser;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DERTaggedObject;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.DefiniteLengthInputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.InMemoryRepresentable;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.IndefiniteLengthInputStream;
import macromedia.externals.org.bouncycastle_1_60_0_0.asn1.StreamUtil;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;
    private final byte[][] tmpBuffers;

    public ASN1StreamParser(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit((InputStream)inputStream));
    }

    public ASN1StreamParser(InputStream inputStream, int n2) {
        this._in = inputStream;
        this._limit = n2;
        this.tmpBuffers = new byte[11][];
    }

    public ASN1StreamParser(byte[] byArray) {
        this((InputStream)new ByteArrayInputStream(byArray), byArray.length);
    }

    ASN1Encodable readIndef(int n2) throws IOException {
        switch (n2) {
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(n2));
    }

    ASN1Encodable readImplicit(boolean bl2, int n2) throws IOException {
        if (this._in instanceof IndefiniteLengthInputStream) {
            if (!bl2) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            return this.readIndef(n2);
        }
        if (bl2) {
            switch (n2) {
                case 17: {
                    return new DERSetParser(this);
                }
                case 16: {
                    return new DERSequenceParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
            }
        } else {
            switch (n2) {
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
                case 4: {
                    return new DEROctetStringParser((DefiniteLengthInputStream)this._in);
                }
            }
        }
        throw new ASN1Exception("implicit tagging not implemented");
    }

    ASN1Primitive readTaggedObject(boolean bl2, int n2) throws IOException {
        if (!bl2) {
            DefiniteLengthInputStream definiteLengthInputStream = (DefiniteLengthInputStream)this._in;
            return new DERTaggedObject(false, n2, (ASN1Encodable)new DEROctetString(definiteLengthInputStream.toByteArray()));
        }
        ASN1EncodableVector aSN1EncodableVector = this.readVector();
        if (this._in instanceof IndefiniteLengthInputStream) {
            return aSN1EncodableVector.size() == 1 ? new BERTaggedObject(true, n2, aSN1EncodableVector.get(0)) : new BERTaggedObject(false, n2, (ASN1Encodable)BERFactory.createSequence((ASN1EncodableVector)aSN1EncodableVector));
        }
        return aSN1EncodableVector.size() == 1 ? new DERTaggedObject(true, n2, aSN1EncodableVector.get(0)) : new DERTaggedObject(false, n2, (ASN1Encodable)DERFactory.createSequence((ASN1EncodableVector)aSN1EncodableVector));
    }

    public ASN1Encodable readObject() throws IOException {
        int n2 = this._in.read();
        if (n2 == -1) {
            return null;
        }
        this.set00Check(false);
        int n3 = ASN1InputStream.readTagNumber((InputStream)this._in, (int)n2);
        boolean bl2 = (n2 & 0x20) != 0;
        int n4 = ASN1InputStream.readLength((InputStream)this._in, (int)this._limit);
        if (n4 < 0) {
            if (!bl2) {
                throw new IOException("indefinite-length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this._in, this._limit);
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser((InputStream)indefiniteLengthInputStream, this._limit);
            if ((n2 & 0x40) != 0) {
                return new BERApplicationSpecificParser(n3, aSN1StreamParser);
            }
            if ((n2 & 0x80) != 0) {
                return new BERTaggedObjectParser(true, n3, aSN1StreamParser);
            }
            return aSN1StreamParser.readIndef(n3);
        }
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this._in, n4);
        if ((n2 & 0x40) != 0) {
            return new DERApplicationSpecific(bl2, n3, definiteLengthInputStream.toByteArray());
        }
        if ((n2 & 0x80) != 0) {
            return new BERTaggedObjectParser(bl2, n3, new ASN1StreamParser((InputStream)definiteLengthInputStream));
        }
        if (bl2) {
            switch (n3) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser((InputStream)definiteLengthInputStream));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser((InputStream)definiteLengthInputStream));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser((InputStream)definiteLengthInputStream));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser((InputStream)definiteLengthInputStream));
                }
            }
            throw new IOException("unknown tag " + n3 + " encountered");
        }
        switch (n3) {
            case 4: {
                return new DEROctetStringParser(definiteLengthInputStream);
            }
        }
        try {
            return ASN1InputStream.createPrimitiveDERObject((int)n3, (DefiniteLengthInputStream)definiteLengthInputStream, (byte[][])this.tmpBuffers);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception("corrupted stream detected", (Throwable)illegalArgumentException);
        }
    }

    private void set00Check(boolean bl2) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(bl2);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        ASN1Encodable aSN1Encodable;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((aSN1Encodable = this.readObject()) != null) {
            if (aSN1Encodable instanceof InMemoryRepresentable) {
                aSN1EncodableVector.add((ASN1Encodable)((InMemoryRepresentable)aSN1Encodable).getLoadedObject());
                continue;
            }
            aSN1EncodableVector.add((ASN1Encodable)aSN1Encodable.toASN1Primitive());
        }
        return aSN1EncodableVector;
    }
}

